package com.inqmy.ats;

import java.util.Properties;

/**
 *
 * @author Tzvetan Georgiev (tsvetan.georgiev@sap.com)
 * @version 1.0
 */

public interface ClusterEnvironment extends Environment {

  public static String JAVA_VERSION = "Java version";
  public static String OS = "Operating system";
  public static String OS_VERSION = "Operating system version";
  public static String JVM_VERSION = "Java virtual machine version";
  public static String JVM_VENDOR = "Java virtual machine vendor";
  public static String JVM_NAME = "Java virtual machine name";
  public static String JAVA_USER_DIR = "Java user directory";

  public int[] getServerIds();

  public int[] getDispatcherIds();

  public String[] getServerNames();

  public String[] getDispatcherNames();

  public boolean isCluster();

  public void startService(String serviceName , int[] clusterIds) throws Exception;

  public void stopService(String serviceName , int[] clusterIds) throws Exception;

  public boolean isServiceStarted(String serviceName , int clusterId) throws Exception;

  public Properties getServerInfo(int clusterId);

  public String getServerInfo(int clusterId , String keyName);

}
