/**
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 * @author Dirk Sabiwalsky
 * @version $Id: //kmgmt/bc.sf.service/60NW_SP_COR/src/_cache/java/api/com/sapportals/wcm/service/cache/ICacheService.java#3 $
 */

package com.sapportals.wcm.service.cache;

import java.util.Properties;

import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.util.cache.*;
import com.sapportals.wcm.service.IService;


/**
 * Provides a service to create caches.
 */
public interface ICacheService
extends IService {

  /**
   * Get a new, unique cache ID that can be used in a call to
   * <code>getCache(cacheID,properties)</code>.
   * @return a <code>String</code> with a new, internal, unique cache ID.
   */
  public String getUniqueCacheID();

  /**
   * Get a cache for the given ID (and given properties, if cache does not
   * already exist): If no cache exists for the given ID, it will be created
   * with the given properties. If a cache already exists for the given ID,
   * the existing cache is returned and the properties are ignored.
   * @param cacheID a <code>String</code> with the id of the cache to get.
   * @param properties the <code>Properties</code> to use when a new cache for
   *        a non-exisiting ID is to be created.
   * @return an <code>ICache</code> for the given ID (and the given properties,
   *        if the cache didn't already exist).
   */
  public ICache getCache(String cacheID,
                         Properties properties)
                  throws ClassNotFoundException,
                         CacheException;


  /**
   * Get a preconfigured cache (with properties taken from configuration).
   * @param cacheID a <code>String</code> with the id of a preconfigured cache.
   * @return a preconfigured <code>ICache</code> for the given ID.
   */
  public ICache getCache(String cacheID)
                  throws ClassNotFoundException,
                         CacheException;


  /**
   * Get an instance of an <code>IClusterCacheArea</code> for the given
   * area ID.
   * @param ID a <code>String</code> with the area ID of the clustered cache
   *        area.
   * @throws WcmException if the cache area couldn't be created.
   */
  public IClusterCacheArea getCacheArea(String ID)
                                 throws WcmException;


}
