
// ---------------------------------------------------------------------------
// This file has been generated by the Web Dynpro Code Generator
// Note: Manual changes should only take place in the user coding areas
//       i.e. the blocks marked with //@@begin ... //@@end
// ---------------------------------------------------------------------------

/*
 * SAP Copyright (c) 2002
 * All rights reserved
 */

//@@begin version
// @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_clientserver/java/com/sap/tc/webdynpro/clientserver/uielib/standard/api/IWDTab.java#2 $
//@@end

package com.sap.tc.webdynpro.clientserver.uielib.standard.api;

import java.util.Iterator;
import com.sap.tc.webdynpro.progmodel.api.IWDAttributeInfo;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeInfo;
// used libraries
import com.sap.tc.webdynpro.clientserver.uielib.standard.api.*; // Standard
import com.sap.tc.webdynpro.progmodel.api.*; // Core
//@@begin imports
//@@end

/**
 * Web Dynpro Tab API.
 *
 * The Tab element is an individual tab page within a tab strip.
 * The tab consists of a header area, a content area, and an optional toolbar.
 *
 * <p>This type can be called by applications using Web Dynpro, but DO NOT EXTEND OR IMPLEMENT IT!</p>
 *
 * @author SAP
 * @see IWDTabStrip
 * @SAPWebDynproPart 2
 */
public interface IWDTab extends IWDViewElement
{
  
  /**
   * Default value of property <code>enabled</code>.
   */
  public static final boolean DEFAULT_ENABLED = true;
  
  /**
   * Default value of property <code>hasContentPadding</code>.
   */
  public static final boolean DEFAULT_HAS_CONTENT_PADDING = true;
  
  /**
   * Default value of property <code>visible</code>.
   */
  public static final boolean DEFAULT_VISIBLE = true;

  /* Bound Property
     Name: enabled, Visibility: public, Type: Boolean, Initial value: true
     convertible: false
  */

  /**
   * Binds property <code>enabled</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the enabled
   *                property is bound
   */
  public void bindEnabled(String path);

  /**
   * Binds property <code>enabled</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       enabled property is bound
   */
  public void bindEnabled(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>enabled</code>.
   *
   * @return        the path of the context attribute to which the enabled
   *                is currently bound
   */
  public String bindingOfEnabled();

  /**
   * Returns the value of the <code>enabled</code> property.
   * The initial value is <code>true</code>.
   *
   * Specifies whether the tab can be activated to display its content
   *
   * @return      the current value of the enabled property
   * @see #setEnabled(boolean)
   */
  public boolean getEnabled();

  /**
   * Sets property <code>enabled</code> to the new value.
   *
   * @param value     the new value of the enabled property
   * @see #getEnabled()
   */
  public void setEnabled(boolean value);

  /* Bound Property
     Name: hasContentPadding, Visibility: public, Type: Boolean, Initial value: true
     convertible: false
  */

  /**
   * Binds property <code>hasContentPadding</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the hasContentPadding
   *                property is bound
   */
  public void bindHasContentPadding(String path);

  /**
   * Binds property <code>hasContentPadding</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       hasContentPadding property is bound
   */
  public void bindHasContentPadding(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>hasContentPadding</code>.
   *
   * @return        the path of the context attribute to which the hasContentPadding
   *                is currently bound
   */
  public String bindingOfHasContentPadding();

  /**
   * Returns the value of the <code>hasContentPadding</code> property.
   * The initial value is <code>true</code>.
   *
   * Specifies if there is a padding around the content of the tab page.
   *
   * @return      the current value of the hasContentPadding property
   * @see #setHasContentPadding(boolean)
   */
  public boolean getHasContentPadding();

  /**
   * Sets property <code>hasContentPadding</code> to the new value.
   *
   * @param value     the new value of the hasContentPadding property
   * @see #getHasContentPadding()
   */
  public void setHasContentPadding(boolean value);

  /* Bound Property
     Name: visible, Visibility: public, Type: Boolean, Initial value: true
     convertible: false
  */

  /**
   * Binds property <code>visible</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the visible
   *                property is bound
   */
  public void bindVisible(String path);

  /**
   * Binds property <code>visible</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       visible property is bound
   */
  public void bindVisible(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>visible</code>.
   *
   * @return        the path of the context attribute to which the visible
   *                is currently bound
   */
  public String bindingOfVisible();

  /**
   * Returns the value of the <code>visible</code> property.
   * The initial value is <code>true</code>.
   *
   * Specifies whether the tab is displayed.
   *
   * @return      the current value of the visible property
   * @see #setVisible(boolean)
   */
  public boolean getVisible();

  /**
   * Sets property <code>visible</code> to the new value.
   *
   * @param value     the new value of the visible property
   * @see #getVisible()
   */
  public void setVisible(boolean value);

  /* outgoing aggregation:
     Name=Tab.Content, isAbstract=false
Role A: Name=Content, Navigable=true, Aggregation=false, Cardinality=single
Role B: Name=Tab, Navigable=false, Aggregation=true, Cardinality=single
  */

  /**
   * Gets the Content instance.
   *
   * A tab contains a UI element as its content.
   *
   * @return      the current Content
   * @see #setContent(IWDUIElement)
   */
  public IWDUIElement getContent();

  /**
   * Sets the Content instance.
   *
   * @param content    the new content
   * @see #getContent()
   */
  public void setContent(IWDUIElement content);

  /**
   * Destroys the Content instance.
   * Destroyed elements do not exist any longer, i.e. a new element may be
   * created with the same ID.
   */
  public void destroyContent();

  /* outgoing aggregation:
     Name=Tab.Header, isAbstract=false
Role A: Name=Header, Navigable=true, Aggregation=false, Cardinality=single
Role B: Name=Tab, Navigable=false, Aggregation=true, Cardinality=single
  */

  /**
   * Gets the Header instance.
   *
   * The header of a tab contains a caption.
   *
   * @return      the current Header
   * @see #setHeader(IWDCaption)
   */
  public IWDCaption getHeader();

  /**
   * Sets the Header instance.
   *
   * @param header    the new header
   * @see #getHeader()
   */
  public void setHeader(IWDCaption header);

  /**
   * Destroys the Header instance.
   * Destroyed elements do not exist any longer, i.e. a new element may be
   * created with the same ID.
   */
  public void destroyHeader();

  /* outgoing aggregation:
     Name=Tab.ToolBar, isAbstract=false
Role A: Name=ToolBar, Navigable=true, Aggregation=false, Cardinality=single
Role B: Name=Tab, Navigable=false, Aggregation=true, Cardinality=single
  */

  /**
   * Gets the ToolBar instance.
   *
   * A tab may contain a toolbar.
   *
   * @return      the current ToolBar
   * @see #setToolBar(IWDToolBar)
   */
  public IWDToolBar getToolBar();

  /**
   * Sets the ToolBar instance.
   *
   * @param toolBar    the new toolBar
   * @see #getToolBar()
   */
  public void setToolBar(IWDToolBar toolBar);

  /**
   * Destroys the ToolBar instance.
   * Destroyed elements do not exist any longer, i.e. a new element may be
   * created with the same ID.
   */
  public void destroyToolBar();

  /* incoming aggregation:
     Name=TabStrip.Tabs, isAbstract=false
Role A: Name=Tabs, Navigable=true, Aggregation=false, Cardinality=multiple
Role B: Name=TabStrip, Navigable=true, Aggregation=true, Cardinality=single
  */

  /**
   * Returns the current TabStrip.
   *
   * A tab strip consists of a number of tabs.
   *
   * @return      the current TabStrip
   */
  public IWDTabStrip getTabStrip();

//@@begin extensions
//@@end

}
