
// ---------------------------------------------------------------------------
// This file has been generated by the Web Dynpro Code Generator
// Note: Manual changes should only take place in the user coding areas
//       i.e. the blocks marked with //@@begin ... //@@end
// ---------------------------------------------------------------------------

/*
 * SAP Copyright (c) 2002
 * All rights reserved
 */

//@@begin version
// @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_clientserver/java/com/sap/tc/webdynpro/clientserver/uielib/standard/api/IWDMenu.java#3 $
//@@end

package com.sap.tc.webdynpro.clientserver.uielib.standard.api;

import java.util.Iterator;
import com.sap.tc.webdynpro.progmodel.api.IWDAttributeInfo;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeInfo;
// used libraries
import com.sap.tc.webdynpro.clientserver.uielib.standard.api.*; // Standard
import com.sap.tc.webdynpro.progmodel.api.*; // Core
//@@begin imports
//@@end

/**
 * Web Dynpro Menu API.
 *
 * The menu element is a subelement of the Tray UI element. It can be used to execute actions in the tray UI element. Each tray can contain at most one menu UI element . A menu element can contain any number of menu items (MenuItem objects) but no submenus.
 *
 * <p>This type can be called by applications using Web Dynpro, but DO NOT EXTEND OR IMPLEMENT IT!</p>
 *
 * @author SAP
 * @SAPWebDynproPart 2
 */
public interface IWDMenu extends IWDViewElement
{

  /* outgoing aggregation:
     Name=Menu.Items, isAbstract=false
Role A: Name=Items, Navigable=true, Aggregation=false, Cardinality=multiple
Role B: Name=Menu, Navigable=false, Aggregation=true, Cardinality=single
  */

  /**
   * Adds the given Item at the end of the list of Items.
   *
   * @param aMenuItem     the Item to be added into the list
   * @see #getItems()
   */
  public void addItem(IWDMenuItem aMenuItem);

  /**
   * Adds the given Item at the specified index in the list of Items.
   *
   * @param aMenuItem     the Item to be added into the list
   * @param index             zero based index of the insertion position in the list
   * @see #getItems()
   */
  public void addItem(IWDMenuItem aMenuItem, int index);

  /**
   * Swaps the Items at the given indices.
   * 
   * @param i index of the first Item to swap
   * @param j index of the second Item to swap
   * @throws IndexOutOfBoundsException If one of the indices is out of bounds
   */
  public void swapItems(int i, int j); 
   
  /**
   * Returns the list of Items.
   *
   * <!-- no documentation from UML model -->
   *
   * @return      an array containing references to the current Items
   */
  public IWDMenuItem[] getItems();

  /**
   * Returns the Item at the given index.
   *
   * @return Item at the given index
   */
  public IWDMenuItem getItem(int index);

  /**
   * Returns the index of the given element in the list of Items
   * or <code>-1</code> if it is not contained in the list.
   */
  public int indexOfItem(IWDMenuItem aMenuItem);
       
  /**
   * Returns the number of Items.
   * 
   * @return the current number of Items.
   * @see #getItems()
   */
  public int numberOfItems();
  
  /**
   * Checks if there exist Items.
   *
   * @return      <code>true</code> if there are Items;
   *              <code>false</code> otherwise.
   * @see #getItems()
   */
  public boolean hasItems();

  /**
   * Returns an iterator over the list of Items.
   *
   * @return      an iterator over the current Items
   * @see #getItems()
   */
  public Iterator iterateItems();

  /**
   * Removes the entry at the given index from the list of Items.
   * This does not destroy the removed element, i.e. it may be added again!
   *
   * @param index       zero based index of the deletion position in the list
   * @return            the removed element
   * @see #addItem(IWDMenuItem)
   * @see #getItems()
   */
  public IWDMenuItem removeItem(int index);

  /**
   * Removes the entry with the given ID from the list of Items.
   * This does not destroy the removed element, i.e. it may be added again!
   * 
   * @param id          unique ID of the element to be deleted from the list
   * @return            the removed element
   * @see #addItem(IWDMenuItem)
   * @see #getItems()
   */
  public IWDMenuItem removeItem(String id);

  /**
   * Removes all entries from the list of Items.
   * This does not destroy the removed elements, i.e. they may be added again!
   * 
   * @see #addItem(IWDMenuItem)
   * @see #getItems()
   */
  public void removeAllItems(); 

  /**
   * Destroys all entries in the list of Items.
   * Destroyed elements do not exist any longer, i.e. new elements may be
   * created with the same IDs.
   */
  public void destroyAllItems();

//@@begin extensions
//@@end

}
