
// ---------------------------------------------------------------------------
// This file has been generated by the Web Dynpro Code Generator
// Note: Manual changes should only take place in the user coding areas
//       i.e. the blocks marked with //@@begin ... //@@end
// ---------------------------------------------------------------------------

/*
 * SAP Copyright (c) 2002
 * All rights reserved
 */

//@@begin version
// @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_clientserver/java/com/sap/tc/webdynpro/clientserver/uielib/standard/api/IWDAbstractInputField.java#5 $
//@@end

package com.sap.tc.webdynpro.clientserver.uielib.standard.api;

import java.util.Iterator;
import com.sap.tc.webdynpro.services.event.api.IWDParameterMapping;
import com.sap.tc.webdynpro.progmodel.api.IWDAttributeInfo;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeInfo;
// used libraries
import com.sap.tc.webdynpro.clientserver.uielib.standard.api.*; // Standard
import com.sap.tc.webdynpro.progmodel.api.*; // Core
//@@begin imports
//@@end

/**
 * Web Dynpro AbstractInputField API.
 *
 * Abstract base class of input fields.
 * Used to display and edit a single line of text.
 * The edited value is given by the property <code>value</code>.
 * If the <code>readOnly</code> property is set to <code>true</code> the value
 * may not be edited.
 * The <code>passwordField</code> property is used to enter text that
 * should not be visible when edited.
 * The <code>length</code> property determines the width of the field
 * measured in characters.
 *
 * <p>This type can be called by applications using Web Dynpro, but DO NOT EXTEND OR IMPLEMENT IT!</p>
 *
 * @author SAP
 * @SAPWebDynproPart 2
 */
public interface IWDAbstractInputField extends IWDUIElement
{

  // Event "onEnter"
  
  /**
   * Returns the action to which the event <code>onEnter</code> is mapped.
   *
   * The action performed when enter is pressed
   *
   * @return the action to which the event is mapped
   * @see #mappingOfOnEnter()
   */
  public IWDAction getOnEnter();

  /**
   * Maps the event <code>onEnter</code> to the given action.
   *
   * @param action  the action for the event
   * @see #getOnEnter()
   */
  public void setOnEnter(IWDAction action);
  
  /**
   * Returns the parameter mapping of event <code>onEnter</code>.
   *
   * <p>To be accessible in a view controller, a UI element event parameter
   * has to be mapped to a controller event handler parameter. This is done
   * by defining a parameter mapping.</p>
   * 
   * <b>Event parameters:</b>
   * <ul>
   * <li>none</li>
   * </ul>
   *
   * @return parameter mapping list.
   * @see #getOnEnter()
   */  
  public IWDParameterMapping mappingOfOnEnter();
  
  
  /**
   * Default value of property <code>alignment</code>.
   */
  public static final WDInputFieldAlignment DEFAULT_ALIGNMENT = WDInputFieldAlignment.AUTO;
  
  /**
   * Default value of property <code>length</code>.
   */
  public static final int DEFAULT_LENGTH = 20;
  
  /**
   * Default value of property <code>passwordField</code>.
   */
  public static final boolean DEFAULT_PASSWORD_FIELD = false;
  
  /**
   * Default value of property <code>readOnly</code>.
   */
  public static final boolean DEFAULT_READ_ONLY = false;
  
  /**
   * Default value of property <code>state</code>.
   */
  public static final WDState DEFAULT_STATE = WDState.NORMAL;
  
  /**
   * Default value of property <code>textDirection</code>.
   */
  public static final WDTextDirection DEFAULT_TEXT_DIRECTION = WDTextDirection.INHERIT;
  
  /**
   * Default value of property <code>width</code>.
   */
  public static final String DEFAULT_WIDTH = "";

  /* Bound Property
     Name: alignment, Visibility: public, Type: InputFieldAlignment, Initial value: auto
     convertible: false
  */

  /**
   * Binds property <code>alignment</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the alignment
   *                property is bound
   */
  public void bindAlignment(String path);

  /**
   * Binds property <code>alignment</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       alignment property is bound
   */
  public void bindAlignment(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>alignment</code>.
   *
   * @return        the path of the context attribute to which the alignment
   *                is currently bound
   */
  public String bindingOfAlignment();

  /**
   * Returns the value of the <code>alignment</code> property.
   * The initial value is <code>WDInputFieldAlignment.AUTO</code>.
   *
   * The alignment of the input field text.
   *
   * @return      the current value of the alignment property
   * @see #setAlignment(WDInputFieldAlignment)
   */
  public WDInputFieldAlignment getAlignment();

  /**
   * Sets property <code>alignment</code> to the new value.
   *
   * @param value     the new value of the alignment property
   * @see #getAlignment()
   */
  public void setAlignment(WDInputFieldAlignment value);

  /* Bound Property
     Name: length, Visibility: public, Type: Integer, Initial value: 20
     convertible: false
  */

  /**
   * Binds property <code>length</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the length
   *                property is bound
   */
  public void bindLength(String path);

  /**
   * Binds property <code>length</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       length property is bound
   */
  public void bindLength(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>length</code>.
   *
   * @return        the path of the context attribute to which the length
   *                is currently bound
   */
  public String bindingOfLength();

  /**
   * Returns the value of the <code>length</code> property.
   * The initial value is <code>null</code>.
   *
   * Determines the length of this input field in characters.
   *
   * @return      the current value of the length property
   * @see #setLength(int)
   */
  public int getLength();

  /**
   * Sets property <code>length</code> to the new value.
   *
   * @param value     the new value of the length property
   * @see #getLength()
   */
  public void setLength(int value);

  /* Bound Property
     Name: passwordField, Visibility: public, Type: Boolean, Initial value: false
     convertible: false
  */

  /**
   * Binds property <code>passwordField</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the passwordField
   *                property is bound
   */
  public void bindPasswordField(String path);

  /**
   * Binds property <code>passwordField</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       passwordField property is bound
   */
  public void bindPasswordField(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>passwordField</code>.
   *
   * @return        the path of the context attribute to which the passwordField
   *                is currently bound
   */
  public String bindingOfPasswordField();

  /**
   * Returns the value of the <code>passwordField</code> property.
   * The initial value is <code>false</code>.
   *
   * If set to <code>true</code>, the entered characters are not echoed in the field.
   *
   * @return      the current value of the passwordField property
   * @see #setPasswordField(boolean)
   */
  public boolean getPasswordField();

  /**
   * Sets property <code>passwordField</code> to the new value.
   *
   * @param value     the new value of the passwordField property
   * @see #getPasswordField()
   */
  public void setPasswordField(boolean value);

  /* Bound Property
     Name: readOnly, Visibility: public, Type: Boolean, Initial value: false
     convertible: false
  */

  /**
   * Binds property <code>readOnly</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the readOnly
   *                property is bound
   */
  public void bindReadOnly(String path);

  /**
   * Binds property <code>readOnly</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       readOnly property is bound
   */
  public void bindReadOnly(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>readOnly</code>.
   *
   * @return        the path of the context attribute to which the readOnly
   *                is currently bound
   */
  public String bindingOfReadOnly();

  /**
   * Returns the value of the <code>readOnly</code> property.
   * The initial value is <code>false</code>.
   *
   * Determines if the input field is editable or not.
   *
   * @return      the current value of the readOnly property
   * @see #setReadOnly(boolean)
   */
  public boolean getReadOnly();

  /**
   * Sets property <code>readOnly</code> to the new value.
   *
   * @param value     the new value of the readOnly property
   * @see #getReadOnly()
   */
  public void setReadOnly(boolean value);

  /* Bound Property
     Name: state, Visibility: public, Type: State, Initial value: normal
     convertible: false
  */

  /**
   * Binds property <code>state</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the state
   *                property is bound
   */
  public void bindState(String path);

  /**
   * Binds property <code>state</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       state property is bound
   */
  public void bindState(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>state</code>.
   *
   * @return        the path of the context attribute to which the state
   *                is currently bound
   */
  public String bindingOfState();

  /**
   * Returns the value of the <code>state</code> property.
   * The initial value is <code>WDState.NORMAL</code>.
   *
   * The state of the input field. This is only a hint used by the renderer.
   * For example, if the input field state is set to <code>required</code>,
   * this is not tested by the framework, but has to be checked by the application.
   *
   * @return      the current value of the state property
   * @see #setState(WDState)
   */
  public WDState getState();

  /**
   * Sets property <code>state</code> to the new value.
   *
   * @param value     the new value of the state property
   * @see #getState()
   */
  public void setState(WDState value);

  /* Bound Property
     Name: textDirection, Visibility: public, Type: TextDirection, Initial value: inherit
     convertible: false
  */

  /**
   * Binds property <code>textDirection</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the textDirection
   *                property is bound
   */
  public void bindTextDirection(String path);

  /**
   * Binds property <code>textDirection</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       textDirection property is bound
   */
  public void bindTextDirection(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>textDirection</code>.
   *
   * @return        the path of the context attribute to which the textDirection
   *                is currently bound
   */
  public String bindingOfTextDirection();

  /**
   * Returns the value of the <code>textDirection</code> property.
   * The initial value is <code>WDTextDirection.INHERIT</code>.
   *
   * Determines the direction of displayed text.
   *
   * @return      the current value of the textDirection property
   * @see #setTextDirection(WDTextDirection)
   */
  public WDTextDirection getTextDirection();

  /**
   * Sets property <code>textDirection</code> to the new value.
   *
   * @param value     the new value of the textDirection property
   * @see #getTextDirection()
   */
  public void setTextDirection(WDTextDirection value);

  /* Bound Property
     Name: value, Visibility: private, Type: String
     convertible: true
  */

  /**
   * Note: This property must be bound to the context!
   *
   * Binds property <code>value</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the value
   *                property is bound
   */
  public void bindValue(String path);

  /**
   * Note: This property must be bound to the context!
   *
   * Binds property <code>value</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       value property is bound
   */
  public void bindValue(IWDAttributeInfo attributeInfo);

  /**
   * Note: This property must be bound to the context!
   *
   * Binding path of property <code>value</code>.
   *
   * @return        the path of the context attribute to which the value
   *                is currently bound
   */
  public String bindingOfValue();

  /**
   * Note: This property must be bound to the context!
   *
   * Returns the value of the <code>value</code> property.
   * The initial value is <code>""</code>.
   *
   * Determines the edited data value.
   *
   * @return      the current value of the value property
   * @see #setValue(String)
   */
  public String getValue();

  /**
   * Note: This property must be bound to the context!
   *
   * Sets property <code>value</code> to the new value.
   *
   * @param value     the new value of the value property
   * @see #getValue()
   */
  public void setValue(String value);

  /* Bound Property
     Name: width, Visibility: public, Type: String
     convertible: false
  */

  /**
   * Binds property <code>width</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the width
   *                property is bound
   */
  public void bindWidth(String path);

  /**
   * Binds property <code>width</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       width property is bound
   */
  public void bindWidth(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>width</code>.
   *
   * @return        the path of the context attribute to which the width
   *                is currently bound
   */
  public String bindingOfWidth();

  /**
   * Returns the value of the <code>width</code> property.
   * The initial value is <code>""</code>.
   *
   * The width (CSS size) of a InputField.
   *
   * @return      the current value of the width property
   * @see #setWidth(String)
   */
  public String getWidth();

  /**
   * Sets property <code>width</code> to the new value.
   *
   * @param value     the new value of the width property
   * @see #getWidth()
   */
  public void setWidth(String value);

//@@begin extensions
//@@end

}
