
// ---------------------------------------------------------------------------
// This file has been generated by the Web Dynpro Code Generator
// Note: Manual changes should only take place in the user coding areas
//       i.e. the blocks marked with //@@begin ... //@@end
// ---------------------------------------------------------------------------

/*
 * SAP Copyright (c) 2002
 * All rights reserved
 */

//@@begin version
// @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_clientserver/java/com/sap/tc/webdynpro/clientserver/uielib/standard/api/IWDAbstractDropDownByKey.java#2 $
//@@end

package com.sap.tc.webdynpro.clientserver.uielib.standard.api;

import java.util.Iterator;
import com.sap.tc.webdynpro.services.event.api.IWDParameterMapping;
import com.sap.tc.webdynpro.progmodel.api.IWDAttributeInfo;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeInfo;
// used libraries
import com.sap.tc.webdynpro.clientserver.uielib.standard.api.*; // Standard
import com.sap.tc.webdynpro.progmodel.api.*; // Core
//@@begin imports
//@@end

/**
 * Web Dynpro AbstractDropDownByKey API.
 *
 * Abstract base class of drop-down list classes with key based context binding.
 * Represents a one-from-many selection visualized by a text field, a button and a drop-down list.
 * The selected value is displayed in the text field, the list of all selectable values is displayed
 * in the drop-down list which appears when the button is pressed.
 * <p>
 * <strong>Data binding:</strong>
 * <br>
 * The set of selectable keys, displayed texts and the selected key are retrieved from a context.
 * This context must provide an attribute <code>y</code> of a type having a value set.
 * The selectable keys of the drop-down list are the keys of this value set,
 * the displayed texts are the corresponding values.
 * The currently selected key is the current value of the attribute <code>y</code>.
 * <p>
 * The property <code>selectedKey</code> must be bound to the attribute <code>y</code>.
 *
 * <p>This type can be called by applications using Web Dynpro, but DO NOT EXTEND OR IMPLEMENT IT!</p>
 *
 * @author SAP
 * @see com.sap.dictionary.runtime.ISimpleType
 * @see com.sap.typeservices.ISimpleValueSet
 * @SAPWebDynproPart 2
 */
public interface IWDAbstractDropDownByKey extends IWDAbstractDropDown
{

  // Event "onSelect"
  
  /**
   * Returns the action to which the event <code>onSelect</code> is mapped.
   *
   * The action performed when the selection of this drop-down list box is changed.
   * Event parameter is the key of the new selected entry.
   *
   * @return the action to which the event is mapped
   * @see #mappingOfOnSelect()
   */
  public IWDAction getOnSelect();

  /**
   * Maps the event <code>onSelect</code> to the given action.
   *
   * @param action  the action for the event
   * @see #getOnSelect()
   */
  public void setOnSelect(IWDAction action);
  
  /**
   * Returns the parameter mapping of event <code>onSelect</code>.
   *
   * <p>To be accessible in a view controller, a UI element event parameter
   * has to be mapped to a controller event handler parameter. This is done
   * by defining a parameter mapping.</p>
   * 
   * <b>Event parameters:</b>
   * <ul>
   * <li>String key - The key of the new selected entry.</li>
   * </ul>
   *
   * @return parameter mapping list.
   * @see #getOnSelect()
   */  
  public IWDParameterMapping mappingOfOnSelect();
  

  /* Bound Property
     Name: selectedKey, Visibility: private, Type: String
     convertible: true
  */

  /**
   * Note: This property must be bound to the context!
   *
   * Binds property <code>selectedKey</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the selectedKey
   *                property is bound
   */
  public void bindSelectedKey(String path);

  /**
   * Note: This property must be bound to the context!
   *
   * Binds property <code>selectedKey</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       selectedKey property is bound
   */
  public void bindSelectedKey(IWDAttributeInfo attributeInfo);

  /**
   * Note: This property must be bound to the context!
   *
   * Binding path of property <code>selectedKey</code>.
   *
   * @return        the path of the context attribute to which the selectedKey
   *                is currently bound
   */
  public String bindingOfSelectedKey();

  /**
   * Note: This property must be bound to the context!
   *
   * Returns the value of the <code>selectedKey</code> property.
   * The initial value is <code>""</code>.
   *
   * The key from the value set that defines the drop-down list's selection.
   *
   * @return      the current value of the selectedKey property
   * @see #setSelectedKey(String)
   */
  public String getSelectedKey();

  /**
   * Note: This property must be bound to the context!
   *
   * Sets property <code>selectedKey</code> to the new value.
   *
   * @param value     the new value of the selectedKey property
   * @see #getSelectedKey()
   */
  public void setSelectedKey(String value);

//@@begin extensions
//@@end

}
