
// ---------------------------------------------------------------------------
// This file has been generated by the Web Dynpro Code Generator
// Note: Manual changes should only take place in the user coding areas
//       i.e. the blocks marked with //@@begin ... //@@end
// ---------------------------------------------------------------------------

/*
 * SAP Copyright (c) 2002
 * All rights reserved
 */

//@@begin version
// @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_clientserver/java/com/sap/tc/webdynpro/clientserver/uielib/pattern/api/IWDPatternTabStrip.java#3 $
//@@end

package com.sap.tc.webdynpro.clientserver.uielib.pattern.api;

import java.util.Iterator;
import com.sap.tc.webdynpro.services.event.api.IWDParameterMapping;
import com.sap.tc.webdynpro.progmodel.api.IWDAttributeInfo;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeInfo;
// used libraries
import com.sap.tc.webdynpro.clientserver.uielib.pattern.api.*; // Pattern
import com.sap.tc.webdynpro.progmodel.api.*; // Core
import com.sap.tc.webdynpro.clientserver.uielib.standard.api.*; // Standard
//@@begin imports
//@@end

/**
 * Web Dynpro PatternTabStrip API.
 *
 * PatternTabStrip is used to display a set of data organized in tabs.
 * One tab at a time may be selected and its content be displayed.
 * A tab is selected by clicking its title. If not all tabs can be displayed,
 * scrolling between the tabs is possible. The PatternTabStrip combines
 * Tray funktionality with a TabStrip.
 * The PatternTabStrip can contain a Menu and several PatternExpandFunction
 * elements (for open/close buttons).
 *
 * <p>This type can be called by applications using Web Dynpro, but DO NOT EXTEND OR IMPLEMENT IT!</p>
 *
 * @author SAP
 * @see IWDPatternExpandFunction
 * @see IWDPatternTab
 * @SAPWebDynproPart 2
 */
public interface IWDPatternTabStrip extends IWDAbstractPatternContainer
{

  // Event "onSelect"
  
  /**
   * Returns the action to which the event <code>onSelect</code> is mapped.
   *
   * The action performed when a PatternTab is selected.
   * Event parameter is the ID of the selected PatternTab.
   *
   * @return the action to which the event is mapped
   * @see #mappingOfOnSelect()
   */
  public IWDAction getOnSelect();

  /**
   * Maps the event <code>onSelect</code> to the given action.
   *
   * @param action  the action for the event
   * @see #getOnSelect()
   */
  public void setOnSelect(IWDAction action);
  
  /**
   * Returns the parameter mapping of event <code>onSelect</code>.
   *
   * <p>To be accessible in a view controller, a UI element event parameter
   * has to be mapped to a controller event handler parameter. This is done
   * by defining a parameter mapping.</p>
   * 
   * <b>Event parameters:</b>
   * <ul>
   * <li>String tab - The ID of the selected PatternTab.</li>
   * </ul>
   *
   * @return parameter mapping list.
   * @see #getOnSelect()
   */  
  public IWDParameterMapping mappingOfOnSelect();
  
  
  /**
   * Default value of property <code>maxVisibleTabs</code>.
   */
  public static final int DEFAULT_MAX_VISIBLE_TABS = 7;
  
  /**
   * Default value of property <code>selectedTab</code>.
   */
  public static final String DEFAULT_SELECTED_TAB = "";

  /* Bound Property
     Name: maxVisibleTabs, Visibility: public, Type: Integer, Initial value: 7
     convertible: false
  */

  /**
   * Binds property <code>maxVisibleTabs</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the maxVisibleTabs
   *                property is bound
   */
  public void bindMaxVisibleTabs(String path);

  /**
   * Binds property <code>maxVisibleTabs</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       maxVisibleTabs property is bound
   */
  public void bindMaxVisibleTabs(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>maxVisibleTabs</code>.
   *
   * @return        the path of the context attribute to which the maxVisibleTabs
   *                is currently bound
   */
  public String bindingOfMaxVisibleTabs();

  /**
   * Returns the value of the <code>maxVisibleTabs</code> property.
   * The initial value is <code>7</code>.
   *
   * Sets the maximum number of visible items for the PatternTab control. If the PatternTabStrip contains more PatternTabs scrolling between PatternTabs is enabled.
   *
   * @return      the current value of the maxVisibleTabs property
   * @see #setMaxVisibleTabs(int)
   */
  public int getMaxVisibleTabs();

  /**
   * Sets property <code>maxVisibleTabs</code> to the new value.
   *
   * @param value     the new value of the maxVisibleTabs property
   * @see #getMaxVisibleTabs()
   */
  public void setMaxVisibleTabs(int value);

  /* Bound Property
     Name: selectedTab, Visibility: public, Type: String
     convertible: false
  */

  /**
   * Binds property <code>selectedTab</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the selectedTab
   *                property is bound
   */
  public void bindSelectedTab(String path);

  /**
   * Binds property <code>selectedTab</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       selectedTab property is bound
   */
  public void bindSelectedTab(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>selectedTab</code>.
   *
   * @return        the path of the context attribute to which the selectedTab
   *                is currently bound
   */
  public String bindingOfSelectedTab();

  /**
   * Returns the value of the <code>selectedTab</code> property.
   * The initial value is <code>""</code>.
   *
   * Contains the ID of the currently selected PatternTab.
   *
   * @return      the current value of the selectedTab property
   * @see #setSelectedTab(String)
   */
  public String getSelectedTab();

  /**
   * Sets property <code>selectedTab</code> to the new value.
   *
   * @param value     the new value of the selectedTab property
   * @see #getSelectedTab()
   */
  public void setSelectedTab(String value);

  /* outgoing aggregation:
     Name=PatternTabStrip.Tabs, isAbstract=false
Role A: Name=Tabs, Navigable=true, Aggregation=false, Cardinality=multiple
Role B: Name=PatternTabStrip, Navigable=true, Aggregation=true, Cardinality=single
  */

  /**
   * Adds the given Tab at the end of the list of Tabs.
   *
   * @param aPatternTab     the Tab to be added into the list
   * @see #getTabs()
   */
  public void addTab(IWDPatternTab aPatternTab);

  /**
   * Adds the given Tab at the specified index in the list of Tabs.
   *
   * @param aPatternTab     the Tab to be added into the list
   * @param index             zero based index of the insertion position in the list
   * @see #getTabs()
   */
  public void addTab(IWDPatternTab aPatternTab, int index);

  /**
   * Swaps the Tabs at the given indices.
   * 
   * @param i index of the first Tab to swap
   * @param j index of the second Tab to swap
   * @throws IndexOutOfBoundsException If one of the indices is out of bounds
   */
  public void swapTabs(int i, int j); 
   
  /**
   * Returns the list of Tabs.
   *
   * <!-- no documentation from UML model -->
   *
   * @return      an array containing references to the current Tabs
   */
  public IWDPatternTab[] getTabs();

  /**
   * Returns the Tab at the given index.
   *
   * @return Tab at the given index
   */
  public IWDPatternTab getTab(int index);

  /**
   * Returns the index of the given element in the list of Tabs
   * or <code>-1</code> if it is not contained in the list.
   */
  public int indexOfTab(IWDPatternTab aPatternTab);
       
  /**
   * Returns the number of Tabs.
   * 
   * @return the current number of Tabs.
   * @see #getTabs()
   */
  public int numberOfTabs();
  
  /**
   * Checks if there exist Tabs.
   *
   * @return      <code>true</code> if there are Tabs;
   *              <code>false</code> otherwise.
   * @see #getTabs()
   */
  public boolean hasTabs();

  /**
   * Returns an iterator over the list of Tabs.
   *
   * @return      an iterator over the current Tabs
   * @see #getTabs()
   */
  public Iterator iterateTabs();

  /**
   * Removes the entry at the given index from the list of Tabs.
   * This does not destroy the removed element, i.e. it may be added again!
   *
   * @param index       zero based index of the deletion position in the list
   * @return            the removed element
   * @see #addTab(IWDPatternTab)
   * @see #getTabs()
   */
  public IWDPatternTab removeTab(int index);

  /**
   * Removes the entry with the given ID from the list of Tabs.
   * This does not destroy the removed element, i.e. it may be added again!
   * 
   * @param id          unique ID of the element to be deleted from the list
   * @return            the removed element
   * @see #addTab(IWDPatternTab)
   * @see #getTabs()
   */
  public IWDPatternTab removeTab(String id);

  /**
   * Removes all entries from the list of Tabs.
   * This does not destroy the removed elements, i.e. they may be added again!
   * 
   * @see #addTab(IWDPatternTab)
   * @see #getTabs()
   */
  public void removeAllTabs(); 

  /**
   * Destroys all entries in the list of Tabs.
   * Destroyed elements do not exist any longer, i.e. new elements may be
   * created with the same IDs.
   */
  public void destroyAllTabs();

//@@begin extensions
//@@end

}
