
// ---------------------------------------------------------------------------
// This file has been generated by the Web Dynpro Code Generator
// Note: Manual changes should only take place in the user coding areas
//       i.e. the blocks marked with //@@begin ... //@@end
// ---------------------------------------------------------------------------

/*
 * SAP Copyright (c) 2002
 * All rights reserved
 */

//@@begin version
// @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_clientserver/java/com/sap/tc/webdynpro/clientserver/uielib/pattern/api/IWDPatternTab.java#4 $
//@@end

package com.sap.tc.webdynpro.clientserver.uielib.pattern.api;

import java.util.Iterator;
import com.sap.tc.webdynpro.progmodel.api.IWDAttributeInfo;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeInfo;
// used libraries
import com.sap.tc.webdynpro.clientserver.uielib.pattern.api.*; // Pattern
import com.sap.tc.webdynpro.progmodel.api.*; // Core
import com.sap.tc.webdynpro.clientserver.uielib.standard.api.*; // Standard
//@@begin imports
//@@end

/**
 * Web Dynpro PatternTab API.
 *
 * PatternTab represents a single tab in a PatternTabStrip.
 * A PatternTab contains a caption that may be activated to display the content of the PatternTab. Each PatternTab can contain several PatternContentAreas. Each area contains a UIElement or a ToolBar.
 *
 * <p>This type can be called by applications using Web Dynpro, but DO NOT EXTEND OR IMPLEMENT IT!</p>
 *
 * @author SAP
 * @see IWDPatternContentArea
 * @see IWDPatternTabStrip
 * @SAPWebDynproPart 2
 */
public interface IWDPatternTab extends IWDViewElement
{
  
  /**
   * Default value of property <code>enabled</code>.
   */
  public static final boolean DEFAULT_ENABLED = true;
  
  /**
   * Default value of property <code>textDirection</code>.
   */
  public static final WDTextDirection DEFAULT_TEXT_DIRECTION = WDTextDirection.INHERIT;
  
  /**
   * Default value of property <code>title</code>.
   */
  public static final String DEFAULT_TITLE = "";
  
  /**
   * Default value of property <code>tooltip</code>.
   */
  public static final String DEFAULT_TOOLTIP = "";
  
  /**
   * Default value of property <code>visible</code>.
   */
  public static final WDVisibility DEFAULT_VISIBLE = WDVisibility.VISIBLE;

  /* Bound Property
     Name: enabled, Visibility: public, Type: Boolean, Initial value: true
     convertible: false
  */

  /**
   * Binds property <code>enabled</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the enabled
   *                property is bound
   */
  public void bindEnabled(String path);

  /**
   * Binds property <code>enabled</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       enabled property is bound
   */
  public void bindEnabled(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>enabled</code>.
   *
   * @return        the path of the context attribute to which the enabled
   *                is currently bound
   */
  public String bindingOfEnabled();

  /**
   * Returns the value of the <code>enabled</code> property.
   * The initial value is <code>true</code>.
   *
   * Determines whether the PatternTab is enabled.
   *
   * @return      the current value of the enabled property
   * @see #setEnabled(boolean)
   */
  public boolean getEnabled();

  /**
   * Sets property <code>enabled</code> to the new value.
   *
   * @param value     the new value of the enabled property
   * @see #getEnabled()
   */
  public void setEnabled(boolean value);

  /* Bound Property
     Name: textDirection, Visibility: public, Type: TextDirection, Initial value: inherit
     convertible: false
  */

  /**
   * Binds property <code>textDirection</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the textDirection
   *                property is bound
   */
  public void bindTextDirection(String path);

  /**
   * Binds property <code>textDirection</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       textDirection property is bound
   */
  public void bindTextDirection(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>textDirection</code>.
   *
   * @return        the path of the context attribute to which the textDirection
   *                is currently bound
   */
  public String bindingOfTextDirection();

  /**
   * Returns the value of the <code>textDirection</code> property.
   * The initial value is <code>WDTextDirection.INHERIT</code>.
   *
   * The text-direction of the button text.
   *
   * @return      the current value of the textDirection property
   * @see #setTextDirection(WDTextDirection)
   */
  public WDTextDirection getTextDirection();

  /**
   * Sets property <code>textDirection</code> to the new value.
   *
   * @param value     the new value of the textDirection property
   * @see #getTextDirection()
   */
  public void setTextDirection(WDTextDirection value);

  /* Bound Property
     Name: title, Visibility: public, Type: TranslatableText
     convertible: true
  */

  /**
   * Binds property <code>title</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the title
   *                property is bound
   */
  public void bindTitle(String path);

  /**
   * Binds property <code>title</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       title property is bound
   */
  public void bindTitle(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>title</code>.
   *
   * @return        the path of the context attribute to which the title
   *                is currently bound
   */
  public String bindingOfTitle();

  /**
   * Returns the value of the <code>title</code> property.
   * The initial value is <code>""</code>.
   *
   * Determines the title of the PatternTab control.
   *
   * @return      the current value of the title property
   * @see #setTitle(String)
   */
  public String getTitle();

  /**
   * Sets property <code>title</code> to the new value.
   *
   * @param value     the new value of the title property
   * @see #getTitle()
   */
  public void setTitle(String value);

  /* Bound Property
     Name: tooltip, Visibility: public, Type: TranslatableText
     convertible: true
  */

  /**
   * Binds property <code>tooltip</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the tooltip
   *                property is bound
   */
  public void bindTooltip(String path);

  /**
   * Binds property <code>tooltip</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       tooltip property is bound
   */
  public void bindTooltip(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>tooltip</code>.
   *
   * @return        the path of the context attribute to which the tooltip
   *                is currently bound
   */
  public String bindingOfTooltip();

  /**
   * Returns the value of the <code>tooltip</code> property.
   * The initial value is <code>""</code>.
   *
   * The text that is displayed when the mouse cursor is moved onto
   * the PatternTab.
   *
   * @return      the current value of the tooltip property
   * @see #setTooltip(String)
   */
  public String getTooltip();

  /**
   * Sets property <code>tooltip</code> to the new value.
   *
   * @param value     the new value of the tooltip property
   * @see #getTooltip()
   */
  public void setTooltip(String value);

  /* Bound Property
     Name: visible, Visibility: public, Type: Visibility, Initial value: visible
     convertible: false
  */

  /**
   * Binds property <code>visible</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the visible
   *                property is bound
   */
  public void bindVisible(String path);

  /**
   * Binds property <code>visible</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       visible property is bound
   */
  public void bindVisible(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>visible</code>.
   *
   * @return        the path of the context attribute to which the visible
   *                is currently bound
   */
  public String bindingOfVisible();

  /**
   * Returns the value of the <code>visible</code> property.
   * The initial value is <code>WDVisibility.VISIBLE</code>.
   *
   * Determines whether the PatternTab is visible.
   *
   * @return      the current value of the visible property
   * @see #setVisible(WDVisibility)
   */
  public WDVisibility getVisible();

  /**
   * Sets property <code>visible</code> to the new value.
   *
   * @param value     the new value of the visible property
   * @see #getVisible()
   */
  public void setVisible(WDVisibility value);

  /* outgoing aggregation:
     Name=PatternTab.Items, isAbstract=false
Role A: Name=Items, Navigable=true, Aggregation=false, Cardinality=multiple
Role B: Name=PatternTab, Navigable=false, Aggregation=true, Cardinality=single
  */

  /**
   * Adds the given Item at the end of the list of Items.
   *
   * @param aPatternContentArea     the Item to be added into the list
   * @see #getItems()
   */
  public void addItem(IWDPatternContentArea aPatternContentArea);

  /**
   * Adds the given Item at the specified index in the list of Items.
   *
   * @param aPatternContentArea     the Item to be added into the list
   * @param index             zero based index of the insertion position in the list
   * @see #getItems()
   */
  public void addItem(IWDPatternContentArea aPatternContentArea, int index);

  /**
   * Swaps the Items at the given indices.
   * 
   * @param i index of the first Item to swap
   * @param j index of the second Item to swap
   * @throws IndexOutOfBoundsException If one of the indices is out of bounds
   */
  public void swapItems(int i, int j); 
   
  /**
   * Returns the list of Items.
   *
   * <!-- no documentation from UML model -->
   *
   * @return      an array containing references to the current Items
   */
  public IWDPatternContentArea[] getItems();

  /**
   * Returns the Item at the given index.
   *
   * @return Item at the given index
   */
  public IWDPatternContentArea getItem(int index);

  /**
   * Returns the index of the given element in the list of Items
   * or <code>-1</code> if it is not contained in the list.
   */
  public int indexOfItem(IWDPatternContentArea aPatternContentArea);
       
  /**
   * Returns the number of Items.
   * 
   * @return the current number of Items.
   * @see #getItems()
   */
  public int numberOfItems();
  
  /**
   * Checks if there exist Items.
   *
   * @return      <code>true</code> if there are Items;
   *              <code>false</code> otherwise.
   * @see #getItems()
   */
  public boolean hasItems();

  /**
   * Returns an iterator over the list of Items.
   *
   * @return      an iterator over the current Items
   * @see #getItems()
   */
  public Iterator iterateItems();

  /**
   * Removes the entry at the given index from the list of Items.
   * This does not destroy the removed element, i.e. it may be added again!
   *
   * @param index       zero based index of the deletion position in the list
   * @return            the removed element
   * @see #addItem(IWDPatternContentArea)
   * @see #getItems()
   */
  public IWDPatternContentArea removeItem(int index);

  /**
   * Removes the entry with the given ID from the list of Items.
   * This does not destroy the removed element, i.e. it may be added again!
   * 
   * @param id          unique ID of the element to be deleted from the list
   * @return            the removed element
   * @see #addItem(IWDPatternContentArea)
   * @see #getItems()
   */
  public IWDPatternContentArea removeItem(String id);

  /**
   * Removes all entries from the list of Items.
   * This does not destroy the removed elements, i.e. they may be added again!
   * 
   * @see #addItem(IWDPatternContentArea)
   * @see #getItems()
   */
  public void removeAllItems(); 

  /**
   * Destroys all entries in the list of Items.
   * Destroyed elements do not exist any longer, i.e. new elements may be
   * created with the same IDs.
   */
  public void destroyAllItems();

  /* incoming aggregation:
     Name=PatternTabStrip.Tabs, isAbstract=false
Role A: Name=Tabs, Navigable=true, Aggregation=false, Cardinality=multiple
Role B: Name=PatternTabStrip, Navigable=true, Aggregation=true, Cardinality=single
  */

  /**
   * Returns the current PatternTabStrip.
   *
   * <!-- no documentation from UML model -->
   *
   * @return      the current PatternTabStrip
   */
  public IWDPatternTabStrip getPatternTabStrip();

//@@begin extensions
//@@end

}
