
// ---------------------------------------------------------------------------
// This file has been generated by the Web Dynpro Code Generator
// Note: Manual changes should only take place in the user coding areas
//       i.e. the blocks marked with //@@begin ... //@@end
// ---------------------------------------------------------------------------

/*
 * SAP Copyright (c) 2002
 * All rights reserved
 */

//@@begin version
// @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_clientserver/java/com/sap/tc/webdynpro/clientserver/uielib/pattern/api/IWDAbstractPatternContainer.java#4 $
//@@end

package com.sap.tc.webdynpro.clientserver.uielib.pattern.api;

import java.util.Iterator;
import com.sap.tc.webdynpro.progmodel.api.IWDAttributeInfo;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeInfo;
// used libraries
import com.sap.tc.webdynpro.clientserver.uielib.pattern.api.*; // Pattern
import com.sap.tc.webdynpro.progmodel.api.*; // Core
import com.sap.tc.webdynpro.clientserver.uielib.standard.api.*; // Standard
//@@begin imports
//@@end

/**
 * Web Dynpro AbstractPatternContainer API.
 *
 * Abstract base class of all PatternContainers.
 *
 * <p>This type can be called by applications using Web Dynpro, but DO NOT EXTEND OR IMPLEMENT IT!</p>
 *
 * @author SAP
 * @SAPWebDynproPart 2
 */
public interface IWDAbstractPatternContainer extends IWDUIElement
{
  
  /**
   * Default value of property <code>accessibilityDescription</code>.
   */
  public static final String DEFAULT_ACCESSIBILITY_DESCRIPTION = "";
  
  /**
   * Default value of property <code>design</code>.
   */
  public static final WDPatternContainerDesign DEFAULT_DESIGN = WDPatternContainerDesign.PLAIN;
  
  /**
   * Default value of property <code>hasContentConnector</code>.
   */
  public static final boolean DEFAULT_HAS_CONTENT_CONNECTOR = false;

  /* Bound Property
     Name: accessibilityDescription, Visibility: public, Type: TranslatableText
     convertible: false
  */

  /**
   * Binds property <code>accessibilityDescription</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the accessibilityDescription
   *                property is bound
   */
  public void bindAccessibilityDescription(String path);

  /**
   * Binds property <code>accessibilityDescription</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       accessibilityDescription property is bound
   */
  public void bindAccessibilityDescription(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>accessibilityDescription</code>.
   *
   * @return        the path of the context attribute to which the accessibilityDescription
   *                is currently bound
   */
  public String bindingOfAccessibilityDescription();

  /**
   * Returns the value of the <code>accessibilityDescription</code> property.
   * The initial value is <code>""</code>.
   *
   * Short description for the PatternContainer (it's like a title) in the accessibility mode. Should be used if no title is available. It is only used if accessibility mode (508) is switched on and will be included into the tooltip. Its read by the screen reader when the whole UI element gets the focus.
   *
   * @return      the current value of the accessibilityDescription property
   * @see #setAccessibilityDescription(String)
   */
  public String getAccessibilityDescription();

  /**
   * Sets property <code>accessibilityDescription</code> to the new value.
   *
   * @param value     the new value of the accessibilityDescription property
   * @see #getAccessibilityDescription()
   */
  public void setAccessibilityDescription(String value);

  /* Bound Property
     Name: design, Visibility: public, Type: PatternContainerDesign, Initial value: plain
     convertible: false
  */

  /**
   * Binds property <code>design</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the design
   *                property is bound
   */
  public void bindDesign(String path);

  /**
   * Binds property <code>design</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       design property is bound
   */
  public void bindDesign(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>design</code>.
   *
   * @return        the path of the context attribute to which the design
   *                is currently bound
   */
  public String bindingOfDesign();

  /**
   * Returns the value of the <code>design</code> property.
   * The initial value is <code>WDPatternContainerDesign.PLAIN</code>.
   *
   * Determines the design of this PatternContainer. For the parameter values see enumeration 'PatternContainerDesign'. Default is 'PLAIN'.
   *
   * @return      the current value of the design property
   * @see #setDesign(WDPatternContainerDesign)
   */
  public WDPatternContainerDesign getDesign();

  /**
   * Sets property <code>design</code> to the new value.
   *
   * @param value     the new value of the design property
   * @see #getDesign()
   */
  public void setDesign(WDPatternContainerDesign value);

  /* Bound Property
     Name: hasContentConnector, Visibility: public, Type: Boolean, Initial value: false
     convertible: false
  */

  /**
   * Binds property <code>hasContentConnector</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the hasContentConnector
   *                property is bound
   */
  public void bindHasContentConnector(String path);

  /**
   * Binds property <code>hasContentConnector</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       hasContentConnector property is bound
   */
  public void bindHasContentConnector(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>hasContentConnector</code>.
   *
   * @return        the path of the context attribute to which the hasContentConnector
   *                is currently bound
   */
  public String bindingOfHasContentConnector();

  /**
   * Returns the value of the <code>hasContentConnector</code> property.
   * The initial value is <code>false</code>.
   *
   * Determines whether the PatternContainer control has a content connector or not. It is a visualisation between two PatternContainer to show that their content is connected to each other.
   *
   * @return      the current value of the hasContentConnector property
   * @see #setHasContentConnector(boolean)
   */
  public boolean getHasContentConnector();

  /**
   * Sets property <code>hasContentConnector</code> to the new value.
   *
   * @param value     the new value of the hasContentConnector property
   * @see #getHasContentConnector()
   */
  public void setHasContentConnector(boolean value);

  /* outgoing aggregation:
     Name=AbstractPatternContainer.ExpandFunctions, isAbstract=false
Role A: Name=ExpandFunctions, Navigable=true, Aggregation=false, Cardinality=multiple
Role B: Name=AbstractPatternContainer, Navigable=true, Aggregation=true, Cardinality=single
  */

  /**
   * Adds the given ExpandFunction at the end of the list of ExpandFunctions.
   *
   * @param aPatternExpandFunction     the ExpandFunction to be added into the list
   * @see #getExpandFunctions()
   */
  public void addExpandFunction(IWDPatternExpandFunction aPatternExpandFunction);

  /**
   * Adds the given ExpandFunction at the specified index in the list of ExpandFunctions.
   *
   * @param aPatternExpandFunction     the ExpandFunction to be added into the list
   * @param index             zero based index of the insertion position in the list
   * @see #getExpandFunctions()
   */
  public void addExpandFunction(IWDPatternExpandFunction aPatternExpandFunction, int index);

  /**
   * Swaps the ExpandFunctions at the given indices.
   * 
   * @param i index of the first ExpandFunction to swap
   * @param j index of the second ExpandFunction to swap
   * @throws IndexOutOfBoundsException If one of the indices is out of bounds
   */
  public void swapExpandFunctions(int i, int j); 
   
  /**
   * Returns the list of ExpandFunctions.
   *
   * <!-- no documentation from UML model -->
   *
   * @return      an array containing references to the current ExpandFunctions
   */
  public IWDPatternExpandFunction[] getExpandFunctions();

  /**
   * Returns the ExpandFunction at the given index.
   *
   * @return ExpandFunction at the given index
   */
  public IWDPatternExpandFunction getExpandFunction(int index);

  /**
   * Returns the index of the given element in the list of ExpandFunctions
   * or <code>-1</code> if it is not contained in the list.
   */
  public int indexOfExpandFunction(IWDPatternExpandFunction aPatternExpandFunction);
       
  /**
   * Returns the number of ExpandFunctions.
   * 
   * @return the current number of ExpandFunctions.
   * @see #getExpandFunctions()
   */
  public int numberOfExpandFunctions();
  
  /**
   * Checks if there exist ExpandFunctions.
   *
   * @return      <code>true</code> if there are ExpandFunctions;
   *              <code>false</code> otherwise.
   * @see #getExpandFunctions()
   */
  public boolean hasExpandFunctions();

  /**
   * Returns an iterator over the list of ExpandFunctions.
   *
   * @return      an iterator over the current ExpandFunctions
   * @see #getExpandFunctions()
   */
  public Iterator iterateExpandFunctions();

  /**
   * Removes the entry at the given index from the list of ExpandFunctions.
   * This does not destroy the removed element, i.e. it may be added again!
   *
   * @param index       zero based index of the deletion position in the list
   * @return            the removed element
   * @see #addExpandFunction(IWDPatternExpandFunction)
   * @see #getExpandFunctions()
   */
  public IWDPatternExpandFunction removeExpandFunction(int index);

  /**
   * Removes the entry with the given ID from the list of ExpandFunctions.
   * This does not destroy the removed element, i.e. it may be added again!
   * 
   * @param id          unique ID of the element to be deleted from the list
   * @return            the removed element
   * @see #addExpandFunction(IWDPatternExpandFunction)
   * @see #getExpandFunctions()
   */
  public IWDPatternExpandFunction removeExpandFunction(String id);

  /**
   * Removes all entries from the list of ExpandFunctions.
   * This does not destroy the removed elements, i.e. they may be added again!
   * 
   * @see #addExpandFunction(IWDPatternExpandFunction)
   * @see #getExpandFunctions()
   */
  public void removeAllExpandFunctions(); 

  /**
   * Destroys all entries in the list of ExpandFunctions.
   * Destroyed elements do not exist any longer, i.e. new elements may be
   * created with the same IDs.
   */
  public void destroyAllExpandFunctions();

  /* outgoing aggregation:
     Name=AbstractPatternContainer.PopupMenu, isAbstract=false
Role A: Name=PopupMenu, Navigable=true, Aggregation=false, Cardinality=single
Role B: Name=AbstractPatternContainer, Navigable=false, Aggregation=true, Cardinality=single
  */

  /**
   * Gets the PopupMenu instance.
   *
   * <!-- no documentation from UML model -->
   *
   * @return      the current PopupMenu
   * @see #setPopupMenu(IWDMenu)
   */
  public IWDMenu getPopupMenu();

  /**
   * Sets the PopupMenu instance.
   *
   * @param popupMenu    the new popupMenu
   * @see #getPopupMenu()
   */
  public void setPopupMenu(IWDMenu popupMenu);

  /**
   * Destroys the PopupMenu instance.
   * Destroyed elements do not exist any longer, i.e. a new element may be
   * created with the same ID.
   */
  public void destroyPopupMenu();

//@@begin extensions
//@@end

}
