package com.sap.tc.webdynpro.clientserver.uielib.officecomp.api;

import com.sap.tc.webdynpro.progmodel.api.IWDController;
import com.sap.tc.webdynpro.services.api.WDHelperNotFoundException;

/**
 * API with some convenience methods to close, save, and show an office document.
 * @author SAP
 * @SAPWebDynproPart 2
 */
public final class WDOfficeControlMethods
{
	/**
	 * @author SAP
	 * @deprecated The showDocument API is deprecated and can be no more used by programmer.Instead the visible property of the OfficeControl should be used to open the document.Instead use #visible="WDVISIBILITY.VISIBLE";
	 * @since SP11  dated: 27,Dec 2004
	 */
  public static void showDocument(IWDController controller, String controlId) 
  { 
   //	The showDocument API will be no more supported.
   //instance.callMethod(controller, controlId, "LoadDocument");
  }     

	/**
	 * @author SAP
	 * @deprecated The closeDocument API is deprecated and can be no more used by programmer.Instead the visible property of the OfficeControl should be used to close the document.Instead use #visible="WDVISIBILITY.BLANK" or visible="WDVISIBILITY.NONE";
	 * @since SP11  dated: 27,Dec 2004
	 */
  public static void closeDocument(IWDController controller, String controlId) 
  {     
    //	The  closeDocument API will be no more supported.     
   //instance.callMethod(controller, controlId, "CloseDocument");
      
  }  

  /**
   * This method will be called by the Application programmer to Save the document from the back end. 
   */
  public static void saveDocument(IWDController controller, String controlId) 
  {  
    instance.callMethod(controller, controlId, "SaveDocument");
  }    

  /**
   * No instances, please.
   */
  private WDOfficeControlMethods()
  {
  }

  /**
   * Singleton instance of helper class in implementation package that we
   * delegate to.
   */
  private static final IWDOfficeControlMethods instance;
  static
  {
    try
    {
      Class clazz = Class.forName("com.sap.tc.webdynpro.clientserver.uielib.officecomp.impl.OfficeControlMethods");
      instance = (IWDOfficeControlMethods) clazz.newInstance();
    }
    catch (Exception e)
    {
      throw new WDHelperNotFoundException(e);
    }
  }
  
  /**
   * Interface to be implemented by some class in implementation package;
   * needed to delegate from API to implementation package.
   */
  public static interface IWDOfficeControlMethods
  {
    public void callMethod(IWDController controller, String controlId, String methodName);
  }
}
