
// ---------------------------------------------------------------------------
// This file has been generated by the Web Dynpro Code Generator
// Note: Manual changes should only take place in the user coding areas
//       i.e. the blocks marked with //@@begin ... //@@end
// ---------------------------------------------------------------------------

/*
 * SAP Copyright (c) 2002
 * All rights reserved
 */

//@@begin version
// @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_clientserver/java/com/sap/tc/webdynpro/clientserver/uielib/mobile/api/IWDRFIDReader.java#2 $
//@@end

package com.sap.tc.webdynpro.clientserver.uielib.mobile.api;

import java.util.Iterator;
import com.sap.tc.webdynpro.services.event.api.IWDParameterMapping;
import com.sap.tc.webdynpro.progmodel.api.IWDAttributeInfo;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeInfo;
// used libraries
import com.sap.tc.webdynpro.clientserver.uielib.mobile.api.*; // Mobile
import com.sap.tc.webdynpro.progmodel.api.*; // Core
//@@begin imports
//@@end

/**
 * Web Dynpro RFIDReader API.
 *
 * RFIDReader is an invisible UIElement that enables a RFID Reader to be used within Pocket PC Internet Explorer. As prerequisite the ActiveX control provided by SAP AG must be installed on the local device.
 *
 * <p>This type can be called by applications using Web Dynpro, but DO NOT EXTEND OR IMPLEMENT IT!</p>
 *
 * @author SAP
 * @SAPWebDynproPart 2
 */
public interface IWDRFIDReader extends IWDUIElement
{

  // Event "onRead"
  
  /**
   * Returns the action to which the event <code>onRead</code> is mapped.
   *
   * Event that will be triggered if RFID tags are read by pressing the RFID key, for example.
   *
   * @return the action to which the event is mapped
   * @see #mappingOfOnRead()
   */
  public IWDAction getOnRead();

  /**
   * Maps the event <code>onRead</code> to the given action.
   *
   * @param action  the action for the event
   * @see #getOnRead()
   */
  public void setOnRead(IWDAction action);
  
  /**
   * Returns the parameter mapping of event <code>onRead</code>.
   *
   * <p>To be accessible in a view controller, a UI element event parameter
   * has to be mapped to a controller event handler parameter. This is done
   * by defining a parameter mapping.</p>
   * 
   * <b>Event parameters:</b>
   * <ul>
   * <li>int failureCount - Event parameter returned to tell the number of tags that are failed to be read.</li>
   * <li>String tagList - Event parameter returned to tell the raw data containing all the tags read. Note the internal format is vendor specific.</li>
   * </ul>
   *
   * @return parameter mapping list.
   * @see #getOnRead()
   */  
  public IWDParameterMapping mappingOfOnRead();
  
  
  /**
   * Default value of property <code>classId</code>.
   */
  public static final String DEFAULT_CLASS_ID = "";
  
  /**
   * Default value of property <code>keyCode</code>.
   */
  public static final String DEFAULT_KEY_CODE = "";

  /* Bound Property
     Name: classId, Visibility: public, Type: String
     convertible: false
  */

  /**
   * Binds property <code>classId</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the classId
   *                property is bound
   */
  public void bindClassId(String path);

  /**
   * Binds property <code>classId</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       classId property is bound
   */
  public void bindClassId(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>classId</code>.
   *
   * @return        the path of the context attribute to which the classId
   *                is currently bound
   */
  public String bindingOfClassId();

  /**
   * Returns the value of the <code>classId</code> property.
   * The initial value is <code>""</code>.
   *
   * Must be set to the ActiveX control name that is used to create the RFIDReader object. In the following example the classId is et to be SAP.RfidG4.
   * var reader = new ActiveXObject('SAP.RfidG4');
   *
   * @return      the current value of the classId property
   * @see #setClassId(String)
   */
  public String getClassId();

  /**
   * Sets property <code>classId</code> to the new value.
   *
   * @param value     the new value of the classId property
   * @see #getClassId()
   */
  public void setClassId(String value);

  /* Bound Property
     Name: keyCode, Visibility: public, Type: String
     convertible: false
  */

  /**
   * Binds property <code>keyCode</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the keyCode
   *                property is bound
   */
  public void bindKeyCode(String path);

  /**
   * Binds property <code>keyCode</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       keyCode property is bound
   */
  public void bindKeyCode(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>keyCode</code>.
   *
   * @return        the path of the context attribute to which the keyCode
   *                is currently bound
   */
  public String bindingOfKeyCode();

  /**
   * Returns the value of the <code>keyCode</code> property.
   * The initial value is <code>""</code>.
   *
   * Property to specify the function key representation in the browser for the key mapping. It is vendor and browser dependent and corresponds exactly to the meta tag attribute name http-equiv. For example, the keyCode is IBrowse_OnKey49 in the follwoing example.
   * <meta http-equiv="IBrowse_OnKey49" content="">
   *
   * @return      the current value of the keyCode property
   * @see #setKeyCode(String)
   */
  public String getKeyCode();

  /**
   * Sets property <code>keyCode</code> to the new value.
   *
   * @param value     the new value of the keyCode property
   * @see #getKeyCode()
   */
  public void setKeyCode(String value);

//@@begin extensions
//@@end

}
