
// ---------------------------------------------------------------------------
// This file has been generated by the Web Dynpro Code Generator
// Note: Manual changes should only take place in the user coding areas
//       i.e. the blocks marked with //@@begin ... //@@end
// ---------------------------------------------------------------------------

/*
 * SAP Copyright (c) 2002
 * All rights reserved
 */

//@@begin version
// @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_clientserver/java/com/sap/tc/webdynpro/clientserver/uielib/mobile/api/IWDBarCodeReader.java#2 $
//@@end

package com.sap.tc.webdynpro.clientserver.uielib.mobile.api;

import java.util.Iterator;
import com.sap.tc.webdynpro.services.event.api.IWDParameterMapping;
import com.sap.tc.webdynpro.progmodel.api.IWDAttributeInfo;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeInfo;
// used libraries
import com.sap.tc.webdynpro.clientserver.uielib.mobile.api.*; // Mobile
import com.sap.tc.webdynpro.progmodel.api.*; // Core
//@@begin imports
//@@end

/**
 * Web Dynpro BarCodeReader API.
 *
 * BarCodeReader is an invisible UIElement that enables a BarCode Scanner to be used within Pocket PC Internet Explorer. Currently only vendors of Intermec and Symbol are supported.
 *
 * <p>This type can be called by applications using Web Dynpro, but DO NOT EXTEND OR IMPLEMENT IT!</p>
 *
 * @author SAP
 * @SAPWebDynproPart 2
 */
public interface IWDBarCodeReader extends IWDUIElement
{

  // Event "onRead"
  
  /**
   * Returns the action to which the event <code>onRead</code> is mapped.
   *
   * Event that will be triggered if a barcode is scanned.
   *
   * @return the action to which the event is mapped
   * @see #mappingOfOnRead()
   */
  public IWDAction getOnRead();

  /**
   * Maps the event <code>onRead</code> to the given action.
   *
   * @param action  the action for the event
   * @see #getOnRead()
   */
  public void setOnRead(IWDAction action);
  
  /**
   * Returns the parameter mapping of event <code>onRead</code>.
   *
   * <p>To be accessible in a view controller, a UI element event parameter
   * has to be mapped to a controller event handler parameter. This is done
   * by defining a parameter mapping.</p>
   * 
   * <b>Event parameters:</b>
   * <ul>
   * <li>String barCode - Event parameter for scanned barcode.</li>
   * <li>String type - Event parameter for the type of barcode standards.</li>
   * </ul>
   *
   * @return parameter mapping list.
   * @see #getOnRead()
   */  
  public IWDParameterMapping mappingOfOnRead();
  
  
  /**
   * Default value of property <code>type</code>.
   */
  public static final WDBarCodeReaderType DEFAULT_TYPE = WDBarCodeReaderType.INTERMEC;

  /* Bound Property
     Name: type, Visibility: public, Type: BarCodeReaderType, Initial value: intermec
     convertible: false
  */

  /**
   * Binds property <code>type</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the type
   *                property is bound
   */
  public void bindType(String path);

  /**
   * Binds property <code>type</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       type property is bound
   */
  public void bindType(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>type</code>.
   *
   * @return        the path of the context attribute to which the type
   *                is currently bound
   */
  public String bindingOfType();

  /**
   * Returns the value of the <code>type</code> property.
   * The initial value is <code>WDBarCodeReaderType.INTERMEC</code>.
   *
   * Determines the type of reader to be used for bar code reading. Note that the proper type is device-dependent.
   *
   * @return      the current value of the type property
   * @see #setType(WDBarCodeReaderType)
   */
  public WDBarCodeReaderType getType();

  /**
   * Sets property <code>type</code> to the new value.
   *
   * @param value     the new value of the type property
   * @see #getType()
   */
  public void setType(WDBarCodeReaderType value);

//@@begin extensions
//@@end

}
