package com.sap.tc.webdynpro.clientserver.uielib.graphics.api;

/**
 * Geographic position in WGS84 format.
 * @author SAP
 */
public final class WDGeoPosition
{
  private double longitude;
  private double latitude;
  private double altitude;
  
  /**
   * Creates a new geoPosition at 0, 0, 0
   */
  public WDGeoPosition()
  {
    this(0., 0., 0.);
  }
  
  /**
   * Creates a new geoPosition with the given longitude and latitude, altitude is set to zero.
   */
  public WDGeoPosition(double longitude, double latitude)
  {
    this(longitude, latitude, 0);
  }
  
  /**
   * Creates a new geoPosition with the given longitude, latitude and altitude
   */
  public WDGeoPosition(double longitude, double latitude, double altitude)
  {
    this.longitude = longitude;
    this.latitude = latitude;
    this.altitude = altitude;
  }
  
  public double getLongitude()
  {
    return longitude;
  }
  
  public double getLatitude()
  {
    return latitude;
  }
  
  public double getAltitude()
  {
    return altitude;
  }
  
  /**
   * Returns true if the two positions have the same latitudes and longitudes.
   */
  public boolean equals(Object obj)
  {
    if (obj == null)
      return false;
    if (obj instanceof WDGeoPosition)
      return (
        longitude == ((WDGeoPosition) obj).longitude
          && latitude == ((WDGeoPosition) obj).latitude
          && altitude == ((WDGeoPosition) obj).altitude);
    else
      return false;
  }
  
  /**
   * @see java.lang.Object#hashCode()
   */
  public int hashCode()
  {
    return (int) (1000 * (longitude + latitude + altitude));
  }
  
  public String toString()
  {
    return "longitude:" + longitude + " latitude:" + latitude + " altitude:" + altitude;
  }
}
