package com.sap.tc.webdynpro.clientserver.uielib.graphics.api;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

import com.sap.tc.webdynpro.services.api.WDHelperNotFoundException;

/**
 * Factory for geo services.
 * 
 * @author SAP
 */
public final class WDGeoFactory
{
  /**
   * Creates a new geo line with the given id.
   */
  public static IWDGeoLine createGeoLine(String id)
  {
    return (IWDGeoLine) createInstance(IWDGeoLine.class, id);
  }

  /**
   * Creates a new geo point with the given id.
   */
  public static IWDGeoPoint createGeoPoint(String id)
  {
    return (IWDGeoPoint) createInstance(IWDGeoPoint.class, id);
  }

  /**
   * Creates a new geo polygon with the given id.
   */
  public static IWDGeoPolygon createGeoPolygon(String id)
  {
    return (IWDGeoPolygon) createInstance(IWDGeoPolygon.class, id);
  }
  
  /**
   * Creates a new converter.
   */
  public static IWDConverter createConverter()
  {
    return (IWDConverter) createInstance(IWDConverter.class);
  }
  
  /**
   * Creates a new geo coder.
   * GEO CODING IS ONLY FUNCTIONAL IF AN IGS WITH ADDITIONAL GEO-SERVICES IS INSTALLED.
   */
  public static IWDGeoCoder createGeoCoder()
  {
    return (IWDGeoCoder) createInstance(IWDGeoCoder.class);
  }
  
  /**
   * Creates a new geo router.
   * GEO ROUTING IS ONLY FUNCTIONAL IF AN IGS WITH ADDITIONAL GEO-SERVICES IS INSTALLED.
   */
  public static IWDGeoRouter createGeoRouter()
  {
    return (IWDGeoRouter) createInstance(IWDGeoRouter.class);
  }
  
  /**
   * Create an instance of the class implementing the given interface.
   */
  private static Object createInstance(Class iface)
  {
    String className = (String) INTERFACE_2_IMPL.get(iface);
    try
    {
      Class clazz = Class.forName(className);
      return clazz.newInstance();
    }
    catch (Exception e)
    {
      throw new WDHelperNotFoundException(e);
    }
  }

  /**
   * Create an instance of the class implementing the given interface.
   * @param id the mandatory id of a GeoObject
   */
  private static Object createInstance(Class iface, String id)
  {
    try
    {
      String className = (String) INTERFACE_2_IMPL.get(iface);
      Class clazz = Class.forName(className);
      Constructor constructor = clazz.getConstructor(CONSTRUCTOR_SIGNATURE);
      return constructor.newInstance(new Object[] {id});
    }
    catch (Exception e)
    {
      throw new WDHelperNotFoundException(e);
    }
  }

  /**
   * Map of implementation class names for interfaces.
   */
  private static final Map INTERFACE_2_IMPL = new HashMap();
  
  static
  {
    INTERFACE_2_IMPL.put(IWDGeoLine.class, "com.sap.tc.webdynpro.clientserver.uielib.graphics.impl.GeoLine");
    INTERFACE_2_IMPL.put(IWDGeoPoint.class, "com.sap.tc.webdynpro.clientserver.uielib.graphics.impl.GeoPoint");
    INTERFACE_2_IMPL.put(IWDGeoPolygon.class, "com.sap.tc.webdynpro.clientserver.uielib.graphics.impl.GeoPolygon");
    INTERFACE_2_IMPL.put(IWDConverter.class, "com.sap.tc.webdynpro.clientserver.uielib.graphics.impl.IgsConverter");
    INTERFACE_2_IMPL.put(IWDGeoCoder.class, "com.sap.tc.webdynpro.clientserver.uielib.graphics.impl.IgsGeoCoder");
    INTERFACE_2_IMPL.put(IWDGeoRouter.class, "com.sap.tc.webdynpro.clientserver.uielib.graphics.impl.IgsGeoRouter");
  }
  
  /**
   * Signature of constructors of implementation classes.
   */
  private static final Class[] CONSTRUCTOR_SIGNATURE = new Class[] {String.class};
  
  /**
   * No instances, please.
   */
  private WDGeoFactory()
  {
  }
}
