package com.sap.tc.webdynpro.clientserver.uielib.graphics.api;

/**
 * Supported WDConverter input formats for objects that are to be converted.
 * @author SAP
 */
public class WDConverterInputFormat
{ 
  /** Tagged Image File Format */
  public static final WDConverterInputFormat TIFF = new WDConverterInputFormat("TIFF");
  
  /** CompuServe Graphics Interchange Format */
  public static final WDConverterInputFormat GIF = new WDConverterInputFormat("GIF");
  
  /** Windows OS/2 Bitmap */
  public static final WDConverterInputFormat BMP = new WDConverterInputFormat("BMP");
  
  /** Portable Network Graphics */
  public static final WDConverterInputFormat PNG = new WDConverterInputFormat("PNG");
  
  /** Joint Picture Expert Group */
  public static final WDConverterInputFormat JPG = new WDConverterInputFormat("JPG");
  
  private String name;
  
  private WDConverterInputFormat(String name)
  {
    this.name = name;
  }
  
  public String toString()
  {
    return name;
  }
}
