package com.sap.tc.webdynpro.clientserver.uielib.graphics.api;

import java.net.URL;
import java.util.List;

import com.sap.tc.webdynpro.services.exceptions.WDException;

/**
 * Provides a java interface to retrieve geo positions from adresses.
 * GEO CODING IS ONLY FUNCTIONAL IF AN IGS WITH ADDITIONAL GEO-SERVICES IS INSTALLED.
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 */
public interface IWDGeoCoder
{
  /**
   * Set the URL of the IGS that provides the GIS services 
   */
  public void setIgsUrl(URL igsURL);
  
  /**
   * Triggers an igs call.
   * @return true if an geo position was generated
   */
  public boolean execute();
  
  public void setMaxCandidates(int maxCandidates);
  
  public void setMinScore(int minScore);
  
  /**
   * Adds an address that is to be geocoded
   */
  public void addAddress(String id, WDGeoCoderAddress address) throws WDException;
  
  /**
   * Clears all addresses that were to be geocoded
   */
  public void clearAddresses();
  
  /**
   * Clears all addresses, minScore and maxCandidates etc.
   */
  public void clearAll();
  
  /**
   * Returns a vector of geocoded result addresses
   */
  public List getResultAddresses(String id);
  
  /**
   * Returns the errors that were detected during the igs request as a string.
   */
  public String getErrors();
}
