
// ---------------------------------------------------------------------------
// This file has been generated by the Web Dynpro Code Generator
// Note: Manual changes should only take place in the user coding areas
//       i.e. the blocks marked with //@@begin ... //@@end
// ---------------------------------------------------------------------------

/*
 * SAP Copyright (c) 2002
 * All rights reserved
 */

//@@begin version
// @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_clientserver/java/com/sap/tc/webdynpro/clientserver/uielib/graphics/api/IWDBusinessGraphics.java#3 $
//@@end

package com.sap.tc.webdynpro.clientserver.uielib.graphics.api;

import java.util.Iterator;
import com.sap.tc.webdynpro.services.event.api.IWDParameterMapping;
import com.sap.tc.webdynpro.progmodel.api.IWDAttributeInfo;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeInfo;
// used libraries
import com.sap.tc.webdynpro.clientserver.uielib.graphics.api.*; // BusinessGraphics
import com.sap.tc.webdynpro.progmodel.api.*; // Core
//@@begin imports
//@@end

/**
 * Web Dynpro BusinessGraphics API.
 *
 * The BusinessGraphics UI element provides several chart types such as vertical bar charts or pie charts, that can be used for the graphical illustration of data and data relationships. In addition, there are more complex chart types such as portfolio and gantt that can help the user of your Web application to make decisions for corporate planning or find information in general.
 *
 * <p>This type can be called by applications using Web Dynpro, but DO NOT EXTEND OR IMPLEMENT IT!</p>
 *
 * @author SAP
 * @SAPWebDynproPart 2
 */
public interface IWDBusinessGraphics extends IWDAbstractIgsElement
{

  // Event "onAction"
  
  /**
   * Returns the action to which the event <code>onAction</code> is mapped.
   *
   * <!-- no documentation from UML model -->
   *
   * @return the action to which the event is mapped
   * @see #mappingOfOnAction()
   */
  public IWDAction getOnAction();

  /**
   * Maps the event <code>onAction</code> to the given action.
   *
   * @param action  the action for the event
   * @see #getOnAction()
   */
  public void setOnAction(IWDAction action);
  
  /**
   * Returns the parameter mapping of event <code>onAction</code>.
   *
   * <p>To be accessible in a view controller, a UI element event parameter
   * has to be mapped to a controller event handler parameter. This is done
   * by defining a parameter mapping.</p>
   * 
   * <b>Event parameters:</b>
   * <ul>
   * <li>String id - </li>
   * </ul>
   *
   * @return parameter mapping list.
   * @see #getOnAction()
   */  
  public IWDParameterMapping mappingOfOnAction();
  
  
  /**
   * Default value of property <code>backgroundColor</code>.
   */
  public static final String DEFAULT_BACKGROUND_COLOR = "";
  
  /**
   * Default value of property <code>chartType</code>.
   */
  public static final WDBusinessGraphicsType DEFAULT_CHART_TYPE = WDBusinessGraphicsType.COLUMNS;
  
  /**
   * Default value of property <code>customizing</code>.
   */
  public static final String DEFAULT_CUSTOMIZING = "";
  
  /**
   * Default value of property <code>dimension</code>.
   */
  public static final WDBusinessGraphicsDimension DEFAULT_DIMENSION = WDBusinessGraphicsDimension.TWO;
  
  /**
   * Default value of property <code>fontFamily</code>.
   */
  public static final String DEFAULT_FONT_FAMILY = "";
  
  /**
   * Default value of property <code>height</code>.
   */
  public static final int DEFAULT_HEIGHT = 300;
  
  /**
   * Default value of property <code>igsUrl</code>.
   */
  public static final String DEFAULT_IGS_URL = "";
  
  /**
   * Default value of property <code>transparentColor</code>.
   */
  public static final String DEFAULT_TRANSPARENT_COLOR = "";
  
  /**
   * Default value of property <code>width</code>.
   */
  public static final int DEFAULT_WIDTH = 300;

  /* Property
     Name: backgroundColor, Visibility: public, Type: String
  */

  /**
   * Returns the value of the <code>backgroundColor</code> property.
   * The initial value is <code>""</code>.
   *
   * The background color.
   *
   * @return the value of the backgroundColor property
   * @see #setBackgroundColor(String)
   */
  public String getBackgroundColor();

  /**
   * Sets property <code>backgroundColor</code> to the given value.
   *
   * @param backgroundColor  the new backgroundColor value
   * @see #getBackgroundColor()
   */
  public void setBackgroundColor(String backgroundColor);

  /* Property
     Name: chartType, Visibility: public, Type: BusinessGraphicsType, Initial value: columns
  */

  /**
   * Returns the value of the <code>chartType</code> property.
   * The initial value is <code>WDBusinessGraphicsType.COLUMNS</code>.
   *
   * Specifies the chart type.
   *
   * @return the value of the chartType property
   * @see #setChartType(WDBusinessGraphicsType)
   */
  public WDBusinessGraphicsType getChartType();

  /**
   * Sets property <code>chartType</code> to the given value.
   *
   * @param chartType  the new chartType value
   * @see #getChartType()
   */
  public void setChartType(WDBusinessGraphicsType chartType);

  /* Property
     Name: customizing, Visibility: public, Type: String
  */

  /**
   * Returns the value of the <code>customizing</code> property.
   * The initial value is <code>""</code>.
   *
   * Describes how the chart is displayed on the screen. This property is assigned to a Web address (URL) linking to an XML file that describes the appearance of the business graphic on the screen - for example, the graphic color, the background color, fonts, and so on. It also specifies whether the graphic displays a legend or not.
   * You can also specify these settings directly in the SAP NetWeaver Developer Studio using the Chart Designer tool. To call the tool, place the cursor on the UI element, click the right mouse button, and select the Start Chart Designer menu option in the context menu.
   * Other attributes (e.g. dimension, fontFamily etc.) override these settings if they collide.
   *
   * @return the value of the customizing property
   * @see #setCustomizing(String)
   */
  public String getCustomizing();

  /**
   * Sets property <code>customizing</code> to the given value.
   *
   * @param customizing  the new customizing value
   * @see #getCustomizing()
   */
  public void setCustomizing(String customizing);

  /* Property
     Name: dimension, Visibility: public, Type: BusinessGraphicsDimension, Initial value: two
  */

  /**
   * Returns the value of the <code>dimension</code> property.
   * The initial value is <code>WDBusinessGraphicsDimension.TWO</code>.
   *
   * Describes the dimensions of the chart. The following dimensions are available:
   * pseudo_three A pseudo-three-dimensional chart, the z-axis is not displayed.
   * three A real three-dimensional chart.
   * two A two-dimensional chart (surface diagram).
   *
   * @return the value of the dimension property
   * @see #setDimension(WDBusinessGraphicsDimension)
   */
  public WDBusinessGraphicsDimension getDimension();

  /**
   * Sets property <code>dimension</code> to the given value.
   *
   * @param dimension  the new dimension value
   * @see #getDimension()
   */
  public void setDimension(WDBusinessGraphicsDimension dimension);

  /* Property
     Name: fontFamily, Visibility: public, Type: String
  */

  /**
   * Returns the value of the <code>fontFamily</code> property.
   * The initial value is <code>""</code>.
   *
   * Specifies the font family for the graphic elements.
   *
   * @return the value of the fontFamily property
   * @see #setFontFamily(String)
   */
  public String getFontFamily();

  /**
   * Sets property <code>fontFamily</code> to the given value.
   *
   * @param fontFamily  the new fontFamily value
   * @see #getFontFamily()
   */
  public void setFontFamily(String fontFamily);

  /* Property
     Name: height, Visibility: public, Type: Integer, Initial value: 300
  */

  /**
   * Returns the value of the <code>height</code> property.
   * The initial value is <code>300</code>.
   *
   * Specifies the height of the chart and can be specified in relative CSS units like em, ex, or percentage.
   *
   * @return the value of the height property
   * @see #setHeight(int)
   */
  public int getHeight();

  /**
   * Sets property <code>height</code> to the given value.
   *
   * @param height  the new height value
   * @see #getHeight()
   */
  public void setHeight(int height);

  /* Property
     Name: igsUrl, Visibility: public, Type: String
  */

  /**
   * Returns the value of the <code>igsUrl</code> property.
   * The initial value is <code>""</code>.
   *
   * This property can specify the Web address (URL) of the server on which the Internet Graphics Service should run. You can use it to overwrite the global URL for which the Web Dynpro System Configuration in the default.properties file has been set.
   *
   * @return the value of the igsUrl property
   * @see #setIgsUrl(String)
   */
  public String getIgsUrl();

  /**
   * Sets property <code>igsUrl</code> to the given value.
   *
   * @param igsUrl  the new igsUrl value
   * @see #getIgsUrl()
   */
  public void setIgsUrl(String igsUrl);

  /* Bound Property
     Name: seriesSource, Visibility: private, Type: Object
     convertible: false
  */

  /**
   * Note: This property must be bound to the context!
   *
   * Binds property <code>seriesSource</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the seriesSource
   *                property is bound
   */
  public void bindSeriesSource(String path);

  /**
   * Note: This property must be bound to the context!
   *
   * Binds property <code>seriesSource</code> to the context node
   * specified by the given node info.
   *
   * @param nodeInfo  the info of the context node to which the
   *                  seriesSource property is bound
   */
  public void bindSeriesSource(IWDNodeInfo nodeInfo);

  /**
   * Note: This property must be bound to the context!
   *
   * Binding path of property <code>seriesSource</code>.
   *
   * @return        the path of the context attribute to which the seriesSource
   *                is currently bound
   */
  public String bindingOfSeriesSource();

  /* Property
     Name: transparentColor, Visibility: public, Type: String
  */

  /**
   * Returns the value of the <code>transparentColor</code> property.
   * The initial value is <code>""</code>.
   *
   * The color that is to be handled as transparent. Colors can be specified as RGB, HSB or X11-like.
   * e.g. "rgb(255,0,0)" or "slateblue".
   *
   * @return the value of the transparentColor property
   * @see #setTransparentColor(String)
   */
  public String getTransparentColor();

  /**
   * Sets property <code>transparentColor</code> to the given value.
   *
   * @param transparentColor  the new transparentColor value
   * @see #getTransparentColor()
   */
  public void setTransparentColor(String transparentColor);

  /* Property
     Name: width, Visibility: public, Type: Integer, Initial value: 300
  */

  /**
   * Returns the value of the <code>width</code> property.
   * The initial value is <code>300</code>.
   *
   * Specifies the width of the chart and can be specified in relative CSS units like em, ex, or percentage.
   *
   * @return the value of the width property
   * @see #setWidth(int)
   */
  public int getWidth();

  /**
   * Sets property <code>width</code> to the given value.
   *
   * @param width  the new width value
   * @see #getWidth()
   */
  public void setWidth(int width);

  /* outgoing aggregation:
     Name=BusinessGraphics.Category, isAbstract=false
Role A: Name=Category, Navigable=true, Aggregation=false, Cardinality=single
Role B: Name=BusinessGraphics, Navigable=true, Aggregation=true, Cardinality=single
  */

  /**
   * Gets the Category instance.
   *
   * <!-- no documentation from UML model -->
   *
   * @return      the current Category
   * @see #setCategory(IWDCategory)
   */
  public IWDCategory getCategory();

  /**
   * Sets the Category instance.
   *
   * @param category    the new category
   * @see #getCategory()
   */
  public void setCategory(IWDCategory category);

  /**
   * Destroys the Category instance.
   * Destroyed elements do not exist any longer, i.e. a new element may be
   * created with the same ID.
   */
  public void destroyCategory();

  /* outgoing aggregation:
     Name=BusinessGraphics.SeriesList, isAbstract=false
Role A: Name=SeriesList, Navigable=true, Aggregation=false, Cardinality=multiple
Role B: Name=BusinessGraphics, Navigable=true, Aggregation=true, Cardinality=single
  */

  /**
   * Adds the given Series at the end of the list of SeriesList.
   *
   * @param aAbstractSeries     the Series to be added into the list
   * @see #getSeriesList()
   */
  public void addSeries(IWDAbstractSeries aAbstractSeries);

  /**
   * Adds the given Series at the specified index in the list of SeriesList.
   *
   * @param aAbstractSeries     the Series to be added into the list
   * @param index             zero based index of the insertion position in the list
   * @see #getSeriesList()
   */
  public void addSeries(IWDAbstractSeries aAbstractSeries, int index);

  /**
   * Swaps the SeriesList at the given indices.
   * 
   * @param i index of the first Series to swap
   * @param j index of the second Series to swap
   * @throws IndexOutOfBoundsException If one of the indices is out of bounds
   */
  public void swapSeriesList(int i, int j); 
   
  /**
   * Returns the list of SeriesList.
   *
   * <!-- no documentation from UML model -->
   *
   * @return      an array containing references to the current SeriesList
   */
  public IWDAbstractSeries[] getSeriesList();

  /**
   * Returns the Series at the given index.
   *
   * @return Series at the given index
   */
  public IWDAbstractSeries getSeries(int index);

  /**
   * Returns the index of the given element in the list of SeriesList
   * or <code>-1</code> if it is not contained in the list.
   */
  public int indexOfSeries(IWDAbstractSeries aAbstractSeries);
       
  /**
   * Returns the number of SeriesList.
   * 
   * @return the current number of SeriesList.
   * @see #getSeriesList()
   */
  public int numberOfSeriesList();
  
  /**
   * Checks if there exist SeriesList.
   *
   * @return      <code>true</code> if there are SeriesList;
   *              <code>false</code> otherwise.
   * @see #getSeriesList()
   */
  public boolean hasSeriesList();

  /**
   * Returns an iterator over the list of SeriesList.
   *
   * @return      an iterator over the current SeriesList
   * @see #getSeriesList()
   */
  public Iterator iterateSeriesList();

  /**
   * Removes the entry at the given index from the list of SeriesList.
   * This does not destroy the removed element, i.e. it may be added again!
   *
   * @param index       zero based index of the deletion position in the list
   * @return            the removed element
   * @see #addSeries(IWDAbstractSeries)
   * @see #getSeriesList()
   */
  public IWDAbstractSeries removeSeries(int index);

  /**
   * Removes the entry with the given ID from the list of SeriesList.
   * This does not destroy the removed element, i.e. it may be added again!
   * 
   * @param id          unique ID of the element to be deleted from the list
   * @return            the removed element
   * @see #addSeries(IWDAbstractSeries)
   * @see #getSeriesList()
   */
  public IWDAbstractSeries removeSeries(String id);

  /**
   * Removes all entries from the list of SeriesList.
   * This does not destroy the removed elements, i.e. they may be added again!
   * 
   * @see #addSeries(IWDAbstractSeries)
   * @see #getSeriesList()
   */
  public void removeAllSeriesList(); 

  /**
   * Destroys all entries in the list of SeriesList.
   * Destroyed elements do not exist any longer, i.e. new elements may be
   * created with the same IDs.
   */
  public void destroyAllSeriesList();

//@@begin extensions

  /**
	 * Sets the customizing directly, only available as method call.
	 * Overwrites customizing from branding, ChartDesigner and convenience properties
	 * @param directCustomzing
	 */
	public void setDirectCustomizing(String directCustomizing);
  
  
//@@end

}
