/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.version;

/**
 * Enumeration of supported options of resources and repositories. <p>
 *
 * Note that the availability of the generally supported options may depend on
 * the resource for which the option was requested, while others apply to the
 * whole repository in general. <p>
 *
 * The supported options may be used by a UI to signal which kind of operations
 * are allowed on a resource or repository. Internally they are used to quickly
 * discover the features of a repository and use only the supported features and
 * bypass the others resp. quickly fail in a requested operation.
 *
 * @author m.breitenfelder@sapportals.com
 * @author julian.reschke@greenbytes.de
 * @created 29. Januar 2003
 */
public final class SupportedOption extends com.sap.netweaver.bc.rf.common.support.SupportedOption {
  /**
   * Repository manager supports versioning operations in general
   */
  public final static SupportedOption VERSIONING =
    new SupportedOption(1, "Versioning");

  /**
   * Resource supports to be taken under or out of version control
   */
  public final static SupportedOption VERSION_CONTROL =
    new SupportedOption(2, "Version Control");

  /**
   * Repository manager supports versioning of collections
   */
  public final static SupportedOption VERSIONED_COLLECTIONS =
    new SupportedOption(3, "Versioned Collection");

  /**
   * Repository manager supports versioning of properties
   */
  public final static SupportedOption VERSIONED_PROPERTIES =
    new SupportedOption(4, "Versioned Properties");

  /**
   * Repository manager supports versioning of links
   */
  public final static SupportedOption VERSIONED_LINKS =
    new SupportedOption(5, "Versioned Links");

  /**
   * Repository manager supports version history on resources
   */
  public final static SupportedOption VERSION_HISTORY_RESOURCES =
    new SupportedOption(6, "Version History Resoucres");

  /**
   * Repository manager supports label methods (see RFC3253: LABEL feature)
   */
  public final static SupportedOption VERSION_LABELS =
    new SupportedOption(7, "Version Labels");

  /**
   * Repository manager supports working resources (see RFC3253: WORKING
   * RESOURCE feature)
   */
  public final static SupportedOption VERSION_WORKING_RESOURCE =
    new SupportedOption(8, "Version Working Resource");

  /**
   * Repository supports the UPDATE method (see RFC3253: UPDATE feature)
   */
  public final static SupportedOption VERSION_UPDATE_FROM =
    new SupportedOption(9, "Version Update From");

  /**
   * Repository supports workspaces (see RFC3253: WORKSPACE feature)
   */
  public final static SupportedOption VERSION_WORKSPACES =
    new SupportedOption(10, "Version Workspaces");

  /**
   * Collection supports workspace creation
   */
  public final static SupportedOption VERSION_CREATE_WORKSPACE =
    new SupportedOption(11, "Version Create Workspace");

  /**
   * Construct object of class SupportedOption.
   *
   * @param id enumeration id
   * @param description enumeration description
   */
  private SupportedOption(int id, String description) {
    super(id, description);
  }
}
