/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.version;

import com.sap.netweaver.bc.rf.common.*;
import com.sap.netweaver.bc.rf.common.exception.*;

/**
 * Holds status information returned upon a successfull call to {@link
 * IResource#checkOut}. <p>
 *
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * @author m.breitenfelder@sapportals.com
 * @created 26. Februar 2003
 * @version $Id: //javabas/com.sapportals.wcm/50_COR/src/java/nemesis/common/com/sapportals/wcm/repository/common/version/ICheckOutInfo.java#3
 *      $
 */
public interface ICheckOutInfo {
  /**
   * If the checkout generated a working resource, it's handle is returned.
   *
   * @return handle of created working resource (may be null)
   * @exception ResourceException Exception raised in failure situation
   */
  public IRid getWorkingRid()
    throws ResourceException;

  /**
   * Returns the expected revision handle.
   *
   * @return the expected revision handle
   */
  public IRid getExpectedRid();

  /**
   * Returns the expected revision ID (version number)
   *
   * @return the expected revision ID (version number)
   */
  public String getExpectedRevisionId();
}
