/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.version;

import com.sap.netweaver.bc.rf.common.*;
import com.sap.netweaver.bc.rf.common.exception.*;

/**
 * Holds status information returned upon a successfull call to <code>
 * IResource.checkin</code> . <p>
 *
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * @author julian.reschke@greenbytes.de
 * @created 26. Februar 2003
 * @version $Id: //javabas/com.sapportals.wcm/50_COR/src/java/nemesis/common/com/sapportals/wcm/repository/common/version/ICheckInInfo.java#3
 *      $
 */

public interface ICheckInInfo {
  /**
   * Returns a handle of the version resource that was created during the
   * checkin operation.
   *
   * @return a handle of the version resource that was created during the
   *      checkin operation.
   */
  public IRid getRid();

  /**
   * Returns the revision ID (version number) of the created version.
   *
   * @return the revision ID (version number)
   */
  public String getRevisionId();

  /**
   * If the resource was checked in with the keepCheckedOut flag, the result of
   * the implicit checkout call is reported.
   *
   * @return the result of the implicit checkout (may be null)
   * @exception ResourceException Exception raised in failure situation
   */
  public ICheckOutInfo getCheckOutInfo()
    throws ResourceException;
}

