/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.version;

import com.sap.netweaver.bc.rf.common.*;
import com.sap.netweaver.bc.rf.common.exception.*;

/**
 * Holds status information returned upon a successfull call to {@link
 * IResource#checkOut}. <p>
 *
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * @author m.breitenfelder@sapportals.com
 * @created 26. Februar 2003
 * @version $Id: //javabas/com.sapportals.wcm/50_COR/src/java/nemesis/common/com/sapportals/wcm/repository/common/version/CheckOutInfo.java#2
 *      $
 */
public class CheckOutInfo implements ICheckOutInfo {
  private final IRid workingRid, expectedRid;
  private final String expectedRevision;

  /**
   * Construct object of class CheckOutInfo.
   *
   * @param expectedRid TBD: Description of the incoming method parameter
   * @param expectedRevision TBD: Description of the incoming method parameter
   * @param workingRid TBD: Description of the incoming method parameter
   */
  public CheckOutInfo(IRid expectedRid, String expectedRevision, IRid workingRid) {
    this.workingRid = workingRid;
    this.expectedRid = expectedRid;
    this.expectedRevision = expectedRevision;
  }

  /**
   * Get the workingRid attribute of the CheckOutInfo object.
   *
   * @return The workingRid value
   * @exception ResourceException Exception raised in failure situation
   */
  public IRid getWorkingRid()
    throws ResourceException {
    return this.workingRid;
  }

  /**
   * Get the expectedRid attribute of the CheckOutInfo object.
   *
   * @return The expectedRid value
   */
  public IRid getExpectedRid() {
    return this.expectedRid;
  }

  /**
   * Get the expectedRevisionId attribute of the CheckOutInfo object.
   *
   * @return The expectedRevisionId value
   */
  public String getExpectedRevisionId() {
    return this.expectedRevision;
  }
}
