/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.transaction;

import com.sap.netweaver.bc.rf.common.exception.*;

/**
 * Read-And-Write interface describing a repository sub manager for
 * transactions.
 *
 * @created 23. Januar 2003
 */
public interface ITransaction {
  /**
   * Complete the transaction associated with the current thread.
   *
   * @exception RepositoryException Exception raised in failure situation
   */
  public void commit()
    throws RepositoryException;

  /**
   * Roll back the transaction associated with the current thread.
   *
   * @exception RepositoryException Exception raised in failure situation
   */
  public void rollback()
    throws RepositoryException;

  /**
   * Modify the transaction associated with the current thread such that the
   * only possible outcome of the transaction is to roll back the transaction.
   */
  void setRollbackOnly();

  /**
   * Get status of the transaction associated with the current thread.
   *
   * @return status of the transaction associated with the current thread
   * @exception RepositoryException Exception raised in failure situation
   */
  public Status getStatus()
    throws RepositoryException;

  /**
   * Get isolation level of the transaction associated with the current thread.
   *
   * @return isolation level of the transaction associated with the current
   *      thread
   * @exception RepositoryException Exception raised in failure situation
   */
  public IsolationLevel getIsolationLevel()
    throws RepositoryException;
}
