/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.support;

import com.sap.netweaver.bc.rf.util.enum.*;

/**
 * Base enumeration class of supported options of resources and repositories.
 * <p>
 *
 * Note that the availability of the generally supported options may depend on
 * the resource for which the option was requested, while others apply to the
 * whole repository in general. <p>
 *
 * The supported options may be used by a UI to signal which kind of operations
 * are allowed on a resource or repository. Internally they are used to quickly
 * discover the features of a repository and use only the supported features and
 * bypass the others resp. quickly fail in a requested operation.
 *
 * @author m.breitenfelder@sapportals.com
 * @author julian.reschke@greenbytes.de
 * @created 29. Januar 2003
 */
public class SupportedOption extends EnumWithDescription {
  /**
   * Construct object of class SupportedOption.
   *
   * @param id enumeration id
   * @param description enumeration description
   */
  protected SupportedOption(int id, String description) {
    super(id, description, false);
  }
}
