/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.security.acl;

import com.sap.netweaver.bc.rf.common.*;
import com.sap.netweaver.bc.rf.util.exception.*;

/**
 * Class implementing exception raised when a specific <code>IAcl</code> already
 * exists.
 *
 * @created 31. Januar 2003
 */
public class AclExistsException extends AclException {
  // Definition of default auto exception log behaviour,
  // used when no user behaviour is supplied during exception construction
  private final static boolean LOG_EXCEPTION_ON_CREATION = true;

  /**
   * Construct object of class AclExistsException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   */
  public AclExistsException(IRid rid) {
    super(rid, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class AclExistsException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  public AclExistsException(IRid rid, boolean logExceptionOnCreation) {
    super(rid, logExceptionOnCreation);
  }

  /**
   * Construct object of class AclExistsException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param rootCause throwable object which caused this exception
   */
  public AclExistsException(IRid rid, Throwable rootCause) {
    super(rid, rootCause, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class AclExistsException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param rootCause throwable object which caused this exception
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  public AclExistsException(IRid rid, Throwable rootCause, boolean logExceptionOnCreation) {
    super(rid, rootCause, logExceptionOnCreation);
  }

  /**
   * Construct object of class AclExistsException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param message not localized message
   */
  public AclExistsException(IRid rid, String message) {
    super(rid, message, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class AclExistsException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param message not localized message
   * @param args message arguments inserted by MessageFormat means
   */
  public AclExistsException(IRid rid, String message, Object[] args) {
    super(rid, message, args, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class AclExistsException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param message not localized message
   * @param rootCause throwable object which caused this exception
   */
  public AclExistsException(IRid rid, String message, Throwable rootCause) {
    super(rid, message, rootCause, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class AclExistsException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param message not localized message
   * @param args message arguments inserted by MessageFormat means
   * @param rootCause throwable object which caused this exception
   */
  public AclExistsException(IRid rid, String message, Object[] args, Throwable rootCause) {
    super(rid, message, args, rootCause, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class AclExistsException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param message not localized message
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  public AclExistsException(IRid rid, String message, boolean logExceptionOnCreation) {
    super(rid, message, logExceptionOnCreation);
  }

  /**
   * Construct object of class AclExistsException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param message not localized message
   * @param args message arguments inserted by MessageFormat means
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  public AclExistsException(IRid rid,
    String message,
    Object[] args,
    boolean logExceptionOnCreation) {
    super(rid, message, args, logExceptionOnCreation);
  }

  /**
   * Construct object of class AclExistsException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param message not localized message
   * @param rootCause throwable object which caused this exception
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  public AclExistsException(IRid rid,
    String message,
    Throwable rootCause,
    boolean logExceptionOnCreation) {
    super(rid, message, rootCause, logExceptionOnCreation);
  }

  /**
   * Construct object of class AclExistsException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param message not localized message
   * @param args message arguments inserted by MessageFormat means
   * @param rootCause throwable object which caused this exception
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  public AclExistsException(IRid rid,
    String message,
    Object[] args,
    Throwable rootCause,
    boolean logExceptionOnCreation) {
    super(rid, message, args, rootCause, logExceptionOnCreation);
  }

  /**
   * Construct object of class AclExistsException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param resourceAccessor resource accessor
   * @param key resource identifier for localized message
   */
  protected AclExistsException(IRid rid, ResourceAccessor resourceAccessor, String key) {
    super(rid, resourceAccessor, key, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class AclExistsException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param resourceAccessor resource accessor
   * @param key resource identifier for localized message
   * @param args message arguments inserted by MessageFormat means
   */
  protected AclExistsException(IRid rid,
    ResourceAccessor resourceAccessor,
    String key,
    Object[] args) {
    super(rid, resourceAccessor, key, args, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class AclExistsException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param resourceAccessor resource accessor
   * @param key resource identifier for localized message
   * @param rootCause throwable object which caused this exception
   */
  protected AclExistsException(IRid rid,
    ResourceAccessor resourceAccessor,
    String key,
    Throwable rootCause) {
    super(rid, resourceAccessor, key, rootCause, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class AclExistsException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param resourceAccessor resource accessor
   * @param key resource identifier for localized message
   * @param args message arguments inserted by MessageFormat means
   * @param rootCause throwable object which caused this exception
   */
  protected AclExistsException(IRid rid,
    ResourceAccessor resourceAccessor,
    String key,
    Object[] args,
    Throwable rootCause) {
    super(rid, resourceAccessor, key, args, rootCause, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class AclExistsException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param resourceAccessor resource accessor
   * @param key resource identifier for localized message
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  protected AclExistsException(IRid rid,
    ResourceAccessor resourceAccessor,
    String key,
    boolean logExceptionOnCreation) {
    super(rid, resourceAccessor, key, logExceptionOnCreation);
  }

  /**
   * Construct object of class AclExistsException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param resourceAccessor resource accessor
   * @param key resource identifier for localized message
   * @param args message arguments inserted by MessageFormat means
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  protected AclExistsException(IRid rid,
    ResourceAccessor resourceAccessor,
    String key,
    Object[] args,
    boolean logExceptionOnCreation) {
    super(rid, resourceAccessor, key, args, logExceptionOnCreation);
  }

  /**
   * Construct object of class AclExistsException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param resourceAccessor resource accessor
   * @param key resource identifier for localized message
   * @param rootCause throwable object which caused this exception
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  protected AclExistsException(IRid rid,
    ResourceAccessor resourceAccessor,
    String key,
    Throwable rootCause,
    boolean logExceptionOnCreation) {
    super(rid, resourceAccessor, key, rootCause, logExceptionOnCreation);
  }

  /**
   * Construct object of class AclExistsException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param resourceAccessor resource accessor
   * @param key resource identifier for localized message
   * @param args message arguments inserted by MessageFormat means
   * @param rootCause throwable object which caused this exception
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  protected AclExistsException(IRid rid,
    ResourceAccessor resourceAccessor,
    String key,
    Object[] args,
    Throwable rootCause,
    boolean logExceptionOnCreation) {
    super(rid, resourceAccessor, key, args, rootCause, logExceptionOnCreation);
  }

  /**
   * Construct object of class AclExistsException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param message not localized message
   */
  protected AclExistsException(IRid rid, ResourceMessage message) {
    super(rid, message, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class AclExistsException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param message not localized message
   * @param rootCause throwable object which caused this exception
   */
  protected AclExistsException(IRid rid, ResourceMessage message, Throwable rootCause) {
    super(rid, message, rootCause, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class AclExistsException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param message not localized message
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  protected AclExistsException(IRid rid, ResourceMessage message, boolean logExceptionOnCreation) {
    super(rid, message, logExceptionOnCreation);
  }

  /**
   * Construct object of class AclExistsException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param message not localized message
   * @param rootCause throwable object which caused this exception
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  protected AclExistsException(IRid rid,
    ResourceMessage message,
    Throwable rootCause,
    boolean logExceptionOnCreation) {
    super(rid, message, rootCause, logExceptionOnCreation);
  }
}
