/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.security;

import java.util.*;

/**
 * Interface describing a permission signifying a basic operation on a resource.
 *
 * @created 23. Januar 2003
 */
public interface IPermission {
  /**
   * Get unique name of permission. IPermission implementations are handled by
   * one security sub manager for which they must be implemented and be unique.
   *
   * @return unique name of permission
   */
  public String getName();

  /**
   * Get description of permission.
   *
   * @return description of permission
   */
  public String getDescription();

  /**
   * Get localized description of permission.
   *
   * @param locale locale to be used for localization
   * @return localized description of permission
   */
  public String getDescription(Locale locale);

  /**
   * Get the local name of the permission, i.e. without the namespace prefix
   *
   * @return localName
   */
  public String getLocalName();
}
