/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.property;

import com.sap.netweaver.bc.rf.common.exception.*;
import com.sap.netweaver.bc.rf.common.property.booleantype.*;
import com.sap.netweaver.bc.rf.common.property.datetype.*;
import com.sap.netweaver.bc.rf.common.property.longtype.*;
import com.sap.netweaver.bc.rf.common.property.stringtype.*;

import java.util.*;

/**
 * Class implementing a factory constructing system properties.
 *
 * @author Vedran Lerenc
 * @created 31. Januar 2003
 * @see IProperty
 * @see PropertyFlags
 */
public class SystemPropertyFactory {
  /**
   * Create system property.
   *
   * @param value system property value
   * @return system property
   * @exception ResourceException Exception raised in failure situation
   * @todo System properties should all use the same resource bundles. Set them.
   */
  public static StringSingleValueProperty createResourceNameProperty(String value)
    throws ResourceException {
    return new StringSingleValueProperty(PropertyName.RESOURCENAME, value, PropertyFlags.constructFlags(false, true, true, false));
  }

  /**
   * Create system property.
   *
   * @param value system property value
   * @return system property
   * @exception ResourceException Exception raised in failure situation
   * @todo System properties should all use the same resource bundles. Set them.
   */
  public static StringSingleValueProperty createResourceTypeProperty(String value)
    throws ResourceException {
    return new StringSingleValueProperty(PropertyName.RESOURCETYPE, value, PropertyFlags.constructFlags(false, false, true, false));
  }

  /**
   * Create system property.
   *
   * @param value system property value
   * @return system property
   * @exception ResourceException Exception raised in failure situation
   * @todo System properties should all use the same resource bundles. Set them.
   */
  public static DateSingleValueProperty createCreatedProperty(Date value)
    throws ResourceException {
    return new DateSingleValueProperty(PropertyType.DATETIME, PropertyName.CREATED, value, PropertyFlags.constructFlags(false, false, true, false));
  }

  /**
   * Create system property.
   *
   * @param value system property value
   * @return system property
   * @exception ResourceException Exception raised in failure situation
   * @todo System properties should all use the same resource bundles. Set them.
   */
  public static StringSingleValueProperty createCreatedByProperty(String value)
    throws ResourceException {
    return new StringSingleValueProperty(PropertyName.CREATEDBY, value, PropertyFlags.constructFlags(false, false, true, false));
  }

  /**
   * Create system property.
   *
   * @param value system property value
   * @return system property
   * @exception ResourceException Exception raised in failure situation
   * @todo System properties should all use the same resource bundles. Set them.
   */
  public static DateSingleValueProperty createModifiedProperty(Date value)
    throws ResourceException {
    return new DateSingleValueProperty(PropertyType.DATETIME, PropertyName.MODIFIED, value, PropertyFlags.constructFlags(false, false, true, false));
  }

  /**
   * Create system property.
   *
   * @param value system property value
   * @return system property
   * @exception ResourceException Exception raised in failure situation
   * @todo System properties should all use the same resource bundles. Set them.
   */
  public static StringSingleValueProperty createModifiedByProperty(String value)
    throws ResourceException {
    return new StringSingleValueProperty(PropertyName.MODIFIEDBY, value, PropertyFlags.constructFlags(false, false, true, false));
  }

  /**
   * Create system property.
   *
   * @param value system property value
   * @return system property
   * @exception ResourceException Exception raised in failure situation
   * @todo System properties should all use the same resource bundles. Set them.
   */
  public static BooleanSingleValueProperty createCollectionProperty(boolean value)
    throws ResourceException {
    return new BooleanSingleValueProperty(PropertyName.COLLECTION, value, PropertyFlags.constructFlags(false, true, true, false));
  }

  /**
   * Create system property.
   *
   * @param value system property value
   * @return system property
   * @exception ResourceException Exception raised in failure situation
   * @todo System properties should all use the same resource bundles. Set them.
   */
  public static LongSingleValueProperty createLinkTypeProperty(int value)
    throws ResourceException {
    return new LongSingleValueProperty(PropertyName.LINKTYPE, value, PropertyFlags.constructFlags(false, true, true, false));
  }

  /**
   * Create system property.
   *
   * @param value system property value
   * @return system property
   * @exception ResourceException Exception raised in failure situation
   * @todo System properties should all use the same resource bundles. Set them.
   */
  public static BooleanSingleValueProperty createReadOnlyProperty(boolean value)
    throws ResourceException {
    return new BooleanSingleValueProperty(PropertyName.READONLY, value, PropertyFlags.constructFlags(false, false, false, false));
  }

  /**
   * Create system property.
   *
   * @param value system property value
   * @return system property
   * @exception ResourceException Exception raised in failure situation
   * @todo System properties should all use the same resource bundles. Set them.
   */
  public static BooleanSingleValueProperty createHiddenProperty(boolean value)
    throws ResourceException {
    return new BooleanSingleValueProperty(PropertyName.HIDDEN, value, PropertyFlags.constructFlags(false, false, false, false));
  }

  /**
   * Create system property.
   *
   * @param value system property value
   * @return system property
   * @exception ResourceException Exception raised in failure situation
   * @todo System properties should all use the same resource bundles. Set them.
   */
  public static StringSingleValueProperty createDisplayNameProperty(String value)
    throws ResourceException {
    return new StringSingleValueProperty(PropertyName.DISPLAYNAME, value, PropertyFlags.constructFlags(false, false, false, false));
  }

  /**
   * Create system property.
   *
   * @param value system property value
   * @return system property
   * @exception ResourceException Exception raised in failure situation
   * @todo System properties should all use the same resource bundles. Set them.
   */
  public static StringSingleValueProperty createDescriptionProperty(String value)
    throws ResourceException {
    return new StringSingleValueProperty(PropertyName.DESCRIPTION, value, PropertyFlags.constructFlags(false, false, false, false));
  }

  /**
   * Create system property.
   *
   * @param value system property value
   * @return system property
   * @exception ResourceException Exception raised in failure situation
   * @todo System properties should all use the same resource bundles. Set them.
   */
  public static LongSingleValueProperty createContentLengthProperty(long value)
    throws ResourceException {
    return new LongSingleValueProperty(PropertyName.CONTENTLENGTH, value, PropertyFlags.constructFlags(false, false, true, false));
  }

  /**
   * Create system property.
   *
   * @param value system property value
   * @return system property
   * @exception ResourceException Exception raised in failure situation
   * @todo System properties should all use the same resource bundles. Set them.
   */
  public static StringSingleValueProperty createContentTypeProperty(String value)
    throws ResourceException {
    return new StringSingleValueProperty(PropertyName.CONTENTTYPE, value, PropertyFlags.constructFlags(false, false, false, false));
  }

  /**
   * Create system property.
   *
   * @param value system property value
   * @return system property
   * @exception ResourceException Exception raised in failure situation
   * @todo System properties should all use the same resource bundles. Set them.
   */
  public static StringSingleValueProperty createContentEncodingProperty(String value)
    throws ResourceException {
    return new StringSingleValueProperty(PropertyName.CONTENTENCODING, value, PropertyFlags.constructFlags(false, false, false, false));
  }

  /**
   * Create system property.
   *
   * @param value system property value
   * @return system property
   * @exception ResourceException Exception raised in failure situation
   * @todo System properties should all use the same resource bundles. Set them.
   */
  public static StringSingleValueProperty createContentLanguageProperty(String value)
    throws ResourceException {
    return new StringSingleValueProperty(PropertyName.CONTENTLANGUAGE, value, PropertyFlags.constructFlags(false, false, false, false));
  }

  /**
   * Create system property.
   *
   * @param value system property value
   * @return system property
   * @exception ResourceException Exception raised in failure situation
   * @todo System properties should all use the same resource bundles. Set them.
   */
  public static StringSingleValueProperty createETagProperty(String value)
    throws ResourceException {
    return new StringSingleValueProperty(PropertyName.ETAG, value, PropertyFlags.constructFlags(false, false, true, false));
  }
}
