/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.property;

/**
 * Enumeration of supported options of resources and repositories. <p>
 *
 * Note that the availability of the generally supported options may depend on
 * the resource for which the option was requested, while others apply to the
 * whole repository in general. <p>
 *
 * The supported options may be used by a UI to signal which kind of operations
 * are allowed on a resource or repository. Internally they are used to quickly
 * discover the features of a repository and use only the supported features and
 * bypass the others resp. quickly fail in a requested operation.
 *
 * @author m.breitenfelder@sapportals.com
 * @author julian.reschke@greenbytes.de
 * @created 29. Januar 2003
 */
public final class SupportedOption extends com.sap.netweaver.bc.rf.common.support.SupportedOption {
  /**
   * Resource supports getting properties (system properties and custom
   * properties)
   */
  public final static SupportedOption GET_PROPERTIES =
    new SupportedOption(1, "Get Properties");

  /**
   * Resource supports setting properties (system properties and custom
   * properties)
   */
  public final static SupportedOption SET_PROPERTIES =
    new SupportedOption(2, "Set Properties");

  /**
   * Repository manager supports property attributes
   */
  public final static SupportedOption PROPERTY_ATTRIBUTES =
    new SupportedOption(3, "Property Attributes");

  /**
   * Repository manager supports multi-valued properties
   */
  public final static SupportedOption PROPERTY_MULTIVALUED =
    new SupportedOption(4, "Property Multivalued");

  /**
   * Construct object of class SupportedOption.
   *
   * @param id enumeration id
   * @param description enumeration description
   */
  private SupportedOption(int id, String description) {
    super(id, description);
  }
}
