/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.property;

import com.sap.netweaver.bc.rf.util.enum.*;

/**
 * Enumeration of property update types.
 *
 * @author Vedran Lerenc
 * @created 23. Januar 2003
 */
public final class PropertyUpdateType extends EnumWithDescription {
  public final static PropertyUpdateType SET =
    new PropertyUpdateType(1, "Set");
  public final static PropertyUpdateType REMOVE =
    new PropertyUpdateType(2, "Remove");

  /**
   * Construct object of class PropertyUpdateType.
   *
   * @param id enumeration id
   * @param description enumeration description
   */
  private PropertyUpdateType(final int id, final String description) {
    super(id, description, false);
  }
}
