/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.property;

import com.sap.netweaver.bc.rf.common.*;
import com.sap.netweaver.bc.rf.util.exception.*;

/**
 * Class implementing exception raised when a property would lose it's property
 * type.
 *
 * @created 31. Januar 2003
 */
public class PropertyTypeLostException extends AbstractPropertyException {
  // Definition of default auto exception log behaviour,
  // used when no user behaviour is supplied during exception construction
  private final static boolean LOG_EXCEPTION_ON_CREATION = true;

  /**
   * Construct object of class PropertyTypeLostException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param propertyName name of the property
   */
  public PropertyTypeLostException(IRid rid, IPropertyName propertyName) {
    super(rid, propertyName, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class PropertyTypeLostException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param propertyName name of the property
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  public PropertyTypeLostException(IRid rid, IPropertyName propertyName, boolean logExceptionOnCreation) {
    super(rid, propertyName, logExceptionOnCreation);
  }

  /**
   * Construct object of class PropertyTypeLostException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param propertyName name of the property
   * @param rootCause throwable object which caused this exception
   */
  public PropertyTypeLostException(IRid rid, IPropertyName propertyName, Throwable rootCause) {
    super(rid, propertyName, rootCause, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class PropertyTypeLostException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param propertyName name of the property
   * @param rootCause throwable object which caused this exception
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  public PropertyTypeLostException(IRid rid, IPropertyName propertyName, Throwable rootCause, boolean logExceptionOnCreation) {
    super(rid, propertyName, rootCause, logExceptionOnCreation);
  }

  /**
   * Construct object of class PropertyTypeLostException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param propertyName name of the property
   * @param message not localized message
   */
  public PropertyTypeLostException(IRid rid, IPropertyName propertyName, String message) {
    super(rid, propertyName, message, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class PropertyTypeLostException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param propertyName name of the property
   * @param message not localized message
   * @param args message arguments inserted by MessageFormat means
   */
  public PropertyTypeLostException(IRid rid, IPropertyName propertyName, String message, Object[] args) {
    super(rid, propertyName, message, args, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class PropertyTypeLostException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param propertyName name of the property
   * @param message not localized message
   * @param rootCause throwable object which caused this exception
   */
  public PropertyTypeLostException(IRid rid, IPropertyName propertyName, String message, Throwable rootCause) {
    super(rid, propertyName, message, rootCause, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class PropertyTypeLostException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param propertyName name of the property
   * @param message not localized message
   * @param args message arguments inserted by MessageFormat means
   * @param rootCause throwable object which caused this exception
   */
  public PropertyTypeLostException(IRid rid, IPropertyName propertyName, String message, Object[] args, Throwable rootCause) {
    super(rid, propertyName, message, args, rootCause, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class PropertyTypeLostException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param propertyName name of the property
   * @param message not localized message
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  public PropertyTypeLostException(IRid rid, IPropertyName propertyName, String message, boolean logExceptionOnCreation) {
    super(rid, propertyName, message, logExceptionOnCreation);
  }

  /**
   * Construct object of class PropertyTypeLostException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param propertyName name of the property
   * @param message not localized message
   * @param args message arguments inserted by MessageFormat means
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  public PropertyTypeLostException(IRid rid, IPropertyName propertyName,
    String message,
    Object[] args,
    boolean logExceptionOnCreation) {
    super(rid, propertyName, message, args, logExceptionOnCreation);
  }

  /**
   * Construct object of class PropertyTypeLostException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param propertyName name of the property
   * @param message not localized message
   * @param rootCause throwable object which caused this exception
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  public PropertyTypeLostException(IRid rid, IPropertyName propertyName,
    String message,
    Throwable rootCause,
    boolean logExceptionOnCreation) {
    super(rid, propertyName, message, rootCause, logExceptionOnCreation);
  }

  /**
   * Construct object of class PropertyTypeLostException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param propertyName name of the property
   * @param message not localized message
   * @param args message arguments inserted by MessageFormat means
   * @param rootCause throwable object which caused this exception
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  public PropertyTypeLostException(IRid rid, IPropertyName propertyName,
    String message,
    Object[] args,
    Throwable rootCause,
    boolean logExceptionOnCreation) {
    super(rid, propertyName, message, args, rootCause, logExceptionOnCreation);
  }

  /**
   * Construct object of class PropertyTypeLostException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param propertyName name of the property
   * @param resourceAccessor resource accessor
   * @param key resource identifier for localized message
   */
  protected PropertyTypeLostException(IRid rid, IPropertyName propertyName, ResourceAccessor resourceAccessor, String key) {
    super(rid, propertyName, resourceAccessor, key, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class PropertyTypeLostException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param propertyName name of the property
   * @param resourceAccessor resource accessor
   * @param key resource identifier for localized message
   * @param args message arguments inserted by MessageFormat means
   */
  protected PropertyTypeLostException(IRid rid, IPropertyName propertyName,
    ResourceAccessor resourceAccessor,
    String key,
    Object[] args) {
    super(rid, propertyName, resourceAccessor, key, args, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class PropertyTypeLostException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param propertyName name of the property
   * @param resourceAccessor resource accessor
   * @param key resource identifier for localized message
   * @param rootCause throwable object which caused this exception
   */
  protected PropertyTypeLostException(IRid rid, IPropertyName propertyName,
    ResourceAccessor resourceAccessor,
    String key,
    Throwable rootCause) {
    super(rid, propertyName, resourceAccessor, key, rootCause, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class PropertyTypeLostException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param propertyName name of the property
   * @param resourceAccessor resource accessor
   * @param key resource identifier for localized message
   * @param args message arguments inserted by MessageFormat means
   * @param rootCause throwable object which caused this exception
   */
  protected PropertyTypeLostException(IRid rid, IPropertyName propertyName,
    ResourceAccessor resourceAccessor,
    String key,
    Object[] args,
    Throwable rootCause) {
    super(rid, propertyName, resourceAccessor, key, args, rootCause, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class PropertyTypeLostException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param propertyName name of the property
   * @param resourceAccessor resource accessor
   * @param key resource identifier for localized message
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  protected PropertyTypeLostException(IRid rid, IPropertyName propertyName,
    ResourceAccessor resourceAccessor,
    String key,
    boolean logExceptionOnCreation) {
    super(rid, propertyName, resourceAccessor, key, logExceptionOnCreation);
  }

  /**
   * Construct object of class PropertyTypeLostException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param propertyName name of the property
   * @param resourceAccessor resource accessor
   * @param key resource identifier for localized message
   * @param args message arguments inserted by MessageFormat means
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  protected PropertyTypeLostException(IRid rid, IPropertyName propertyName,
    ResourceAccessor resourceAccessor,
    String key,
    Object[] args,
    boolean logExceptionOnCreation) {
    super(rid, propertyName, resourceAccessor, key, args, logExceptionOnCreation);
  }

  /**
   * Construct object of class PropertyTypeLostException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param propertyName name of the property
   * @param resourceAccessor resource accessor
   * @param key resource identifier for localized message
   * @param rootCause throwable object which caused this exception
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  protected PropertyTypeLostException(IRid rid, IPropertyName propertyName,
    ResourceAccessor resourceAccessor,
    String key,
    Throwable rootCause,
    boolean logExceptionOnCreation) {
    super(rid, propertyName, resourceAccessor, key, rootCause, logExceptionOnCreation);
  }

  /**
   * Construct object of class PropertyTypeLostException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param propertyName name of the property
   * @param resourceAccessor resource accessor
   * @param key resource identifier for localized message
   * @param args message arguments inserted by MessageFormat means
   * @param rootCause throwable object which caused this exception
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  protected PropertyTypeLostException(IRid rid, IPropertyName propertyName,
    ResourceAccessor resourceAccessor,
    String key,
    Object[] args,
    Throwable rootCause,
    boolean logExceptionOnCreation) {
    super(rid, propertyName, resourceAccessor, key, args, rootCause, logExceptionOnCreation);
  }

  /**
   * Construct object of class PropertyTypeLostException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param propertyName name of the property
   * @param message not localized message
   */
  protected PropertyTypeLostException(IRid rid, IPropertyName propertyName, ResourceMessage message) {
    super(rid, propertyName, message, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class PropertyTypeLostException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param propertyName name of the property
   * @param message not localized message
   * @param rootCause throwable object which caused this exception
   */
  protected PropertyTypeLostException(IRid rid, IPropertyName propertyName, ResourceMessage message, Throwable rootCause) {
    super(rid, propertyName, message, rootCause, LOG_EXCEPTION_ON_CREATION);
  }

  /**
   * Construct object of class PropertyTypeLostException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param propertyName name of the property
   * @param message not localized message
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  protected PropertyTypeLostException(IRid rid, IPropertyName propertyName, ResourceMessage message, boolean logExceptionOnCreation) {
    super(rid, propertyName, message, logExceptionOnCreation);
  }

  /**
   * Construct object of class PropertyTypeLostException.
   *
   * @param rid resource id of the resource this exception is associated with
   *      (if any)
   * @param propertyName name of the property
   * @param message not localized message
   * @param rootCause throwable object which caused this exception
   * @param logExceptionOnCreation when true log the exception now during its
   *      construction
   */
  protected PropertyTypeLostException(IRid rid, IPropertyName propertyName,
    ResourceMessage message,
    Throwable rootCause,
    boolean logExceptionOnCreation) {
    super(rid, propertyName, message, rootCause, logExceptionOnCreation);
  }
}
