/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.property;

import com.sap.netweaver.bc.rf.util.enum.*;

/**
 * Enumeration of property tpyes.
 *
 * @author Vedran Lerenc
 * @created 29. Januar 2003
 */
public final class PropertyType extends EnumWithDescription {
  public final static PropertyType STRING = new PropertyType(1, "String");
  public final static PropertyType INT = new PropertyType(2, "Int");
  public final static PropertyType LONG = new PropertyType(3, "Long");
  public final static PropertyType DATEONLY = new PropertyType(4, "DateOnly");
  public final static PropertyType TIMEONLY = new PropertyType(5, "TimeOnly");
  public final static PropertyType DATETIME = new PropertyType(6, "DateTime");
  public final static PropertyType BOOLEAN = new PropertyType(7, "Boolean");
  public final static PropertyType XML = new PropertyType(8, "XML");

  /**
   * Construct object of class PropertyType.
   *
   * @param id enumeration id
   * @param description enumeration description
   */
  private PropertyType(final int id, final String description) {
    super(id, description, false);
  }
}
