/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.property;

/**
 * Class implementing a property set (create/overwrite) operation.
 *
 * @author Vedran Lerenc
 * @created 29. Januar 2003
 * @see IMutablePropertyManager
 */
public final class PropertySetDescriptor
   implements IPropertyUpdateDescriptor {
  private IProperty property = null;

  /**
   * Construct property set (create/overwrite) operation.
   *
   * @param property property to be set (create/overwrite)
   */
  public PropertySetDescriptor(IProperty property) {
    this.property = property;
  }

  /**
   * Get property update type to be applied to the resource.
   *
   * @return property update type to be applied to the resource
   */
  public PropertyUpdateType getPropertyUpdateType() {
    return PropertyUpdateType.SET;
  }

  /**
   * Get property to be set on the resource.
   *
   * @return property to be set on the resource
   */
  public IProperty getProperty() {
    return this.property;
  }
}
