/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.property;

/**
 * Class implementing a property remove operation.
 *
 * @author Vedran Lerenc
 * @created 29. Januar 2003
 * @see IMutablePropertyManager
 */
public final class PropertyRemoveDescriptor
   implements IPropertyUpdateDescriptor {
  private IPropertyName propertyName = null;

  /**
   * Construct property remove operation.
   *
   * @param propertyName name of property to be removed
   */
  public PropertyRemoveDescriptor(IPropertyName propertyName) {
    this.propertyName = propertyName;
  }

  /**
   * Get property update type to be applied to the resource.
   *
   * @return property update type to be applied to the resource
   */
  public PropertyUpdateType getPropertyUpdateType() {
    return PropertyUpdateType.REMOVE;
  }

  /**
   * Get property name to be removed from the resource.
   *
   * @return property name to be removed from the resource.
   */
  public IPropertyName getPropertyName() {
    return this.propertyName;
  }
}
