/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.property;

import com.sap.netweaver.bc.rf.common.exception.*;

import java.util.*;

/**
 * Read-And-Write interface describing a property, which is part of the resource
 * and describes certain aspects of it. A property has a name ({@link
 * IPropertyName}), type ({@link PropertyType}), some attributes, a natural
 * language description and most important a value. For each type exists a
 * specific property interface and implementation extending this interface.
 *
 * @author Vedran Lerenc
 * @created 29. Januar 2003
 * @see IProperty
 * @see IPropertyName
 * @see PropertyType
 */
public interface IMutableProperty extends IProperty {
  /**
   * Set all attributes for the property at once. The given attribute map will
   * be stored directly (as is - without being copied). Note that this call
   * disconnects the attribute map returned from a getAttributes() call from the
   * property.
   *
   * @param attributes property map holding all attributes
   * @exception ResourceException when the attributes map or the property is
   *      invalid
   */
  public void setAttributes(Properties attributes)
    throws ResourceException;

  /**
   * Remove all attributes for the property at once.
   *
   * @exception ResourceException when the property is invalid
   */
  public void clearAttributes()
    throws ResourceException;

  /**
   * Add attribute for the property.
   *
   * @param attributeName attribute name
   * @param attributeValue attribute value
   * @exception ResourceException when the attribute name or value or the
   *      property is invalid
   */
  public void setAttribute(String attributeName, String attributeValue)
    throws ResourceException;

  /**
   * Remove attribute from the property.
   *
   * @param attributeName attribute name
   * @exception ResourceException when the attribute name or the property is
   *      invalid
   */
  public void removeAttribute(String attributeName)
    throws ResourceException;
}
