/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.namespace;

/**
 * Enumeration of supported options of resources and repositories. <p>
 *
 * Note that the availability of the generally supported options may depend on
 * the resource for which the option was requested, while others apply to the
 * whole repository in general. <p>
 *
 * The supported options may be used by a UI to signal which kind of operations
 * are allowed on a resource or repository. Internally they are used to quickly
 * discover the features of a repository and use only the supported features and
 * bypass the others resp. quickly fail in a requested operation.
 *
 * @author m.breitenfelder@sapportals.com
 * @author julian.reschke@greenbytes.de
 * @created 29. Januar 2003
 */
public final class SupportedOption extends com.sap.netweaver.bc.rf.common.support.SupportedOption {
  /**
   * Resource supports creation of child resources
   */
  public final static SupportedOption CREATE_RESOURCE =
    new SupportedOption(1, "Create Resource");

  /**
   * Repository manager supports creation of collections
   */
  public final static SupportedOption CREATE_COLLECTION =
    new SupportedOption(2, "Create Collection");

  /**
   * Resource supports deletion
   */
  public final static SupportedOption DELETE =
    new SupportedOption(3, "Delete");

  /**
   * Repository manager supports deleting collection of resources deeply
   * (otherwise the framework will do it)
   */
  public final static SupportedOption DELETE_DEEP =
    new SupportedOption(4, "Delete Deep");

  /**
   * Repository manager supports copying resources
   */
  public final static SupportedOption COPY =
    new SupportedOption(5, "Copy");

  /**
   * Repository manager supports copying collections of resources deeply
   * (otherwise the framework will do it)
   */
  public final static SupportedOption COPY_DEEP =
    new SupportedOption(6, "Copy Deep");

  /**
   * Repository manager supports renaming resources
   */
  public final static SupportedOption MOVE =
    new SupportedOption(7, "Move");

  /**
   * Repository manager supports renaming resources
   */
  public final static SupportedOption RENAME =
    new SupportedOption(8, "Rename");

  /**
   * Repository manager supports creating and modifying internal and external
   * links
   */
  public final static SupportedOption LINKING =
    new SupportedOption(9, "Linking");

  /**
   * Repository resolves links on getResource
   */
  public final static SupportedOption RESOLVES_LINKS =
    new SupportedOption(10, "Resolve Links");

  /**
   * TBD: Unknown Function resp. Response is in question: Repository manager
   * supports internal dynamic links, i. e. that when a resource is moved
   * internally, all existing links to it will still link the moved resource.
   * Note that a WebDAV repository manager may report this as available although
   * the remote system doesn't support it. In this case the attempt to create a
   * dynamic link will cause a NotSupportedException.
   */
  public final static SupportedOption INTERNAL_DYNAMIC_LINKS =
    new SupportedOption(11, "Internal Dynamic Links");

  /**
   * Repository manager supports ordered collections
   */
  public final static SupportedOption ORDERED_COLLECTIONS =
    new SupportedOption(12, "Ordered Collections");

  /**
   * Repository manager supports return of collection of resources for
   * findResources() operations Note: Either this or FIND_RESOURCES_ITERATOR
   * must be supported!
   */
  public final static SupportedOption FIND_RESOURCES_COLLECTION =
    new SupportedOption(13, "Find Resources Collection");

  /**
   * Repository manager supports return of iterator for children for
   * findResources() operations Note: Either this or FIND_RESOURCES_COLLECTION
   * must be supported!
   */
  public final static SupportedOption FIND_RESOURCES_ITERATOR =
    new SupportedOption(14, "Find Resources Iterator");

  /**
   * Repository manager supports offset/length positioning in resources list
   * result of findResources() operations Note: Only applicable when
   * FIND_RESOURCES_COLLECTION is supported!
   */
  public final static SupportedOption FIND_RESOURCES_COLLECTION_OFFSET_LENGTH =
    new SupportedOption(15, "Find Resources Collection Offset/Length Positioning");

  /**
   * Repository manager supports offset/length positioning in resources list
   * result of findResources() operations Note: Only applicable when
   * FIND_RESOURCES_COLLECTION is supported!
   */
  public final static SupportedOption FIND_RESOURCES_COLLECTION_RESULTSTATE =
    new SupportedOption(16, "Find Resources Collection Resultstate Reuse");

  /**
   * Repository manager supports start index/fetch size hints for resources
   * iterator result of findResources() operations Note: Only applicable when
   * FIND_RESOURCES_ITERATOR is supported!
   */
  public final static SupportedOption FIND_RESOURCES_ITERATOR_STARTINDEX_FETCHSIZE =
    new SupportedOption(17, "Find Resources Iterator Start index/fetch size Hint");

  /**
   * Repository manager supports basic find of children resources in
   * findResources() operations
   */
  public final static SupportedOption FIND_BASIC_CHILDREN_RESOURCES =
    new SupportedOption(18, "Find Basic Children Resources");

  /**
   * Repository manager supports advanced (query expression and collator) find
   * of children resources in findResources() operations
   */
  public final static SupportedOption FIND_ADVANCED_CHILDREN_RESOURCES =
    new SupportedOption(19, "Find Advanced Children Resources");

  /**
   * Repository manager supports advanced (query expression and collator) find
   * of resources of specific depth search in findResources() operations
   */
  public final static SupportedOption FIND_ADVANCED_DEEP_RESOURCES =
    new SupportedOption(20, "Find Advanced Deep Resources");

  /**
   * Repository manager supports advanced (query expression and collator) find
   * of versioned resources of specific depth search in findResources()
   * operations
   */
  public final static SupportedOption FIND_ADVANCED_DEEP_VERSIONED_RESOURCES =
    new SupportedOption(21, "Find Advanced Deep Versioned Resources");

  /**
   * Repository manager supports return of number of resources of
   * findResources() operations
   */
  public final static SupportedOption COUNT_RESOURCES =
    new SupportedOption(22, "Count Resources");

  /**
   * Repository manager supports non-hierarchical namespace, i.e. parent
   * collections might not exist.
   */
  public final static SupportedOption NON_HIERARCHICAL_NAMESPACE =
    new SupportedOption(23, "Non-hierarchical Namespace");

  /**
   * Construct object of class SupportedOption.
   *
   * @param id enumeration id
   * @param description enumeration description
   */
  private SupportedOption(int id, String description) {
    super(id, description);
  }
}
