/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.namespace;
import com.sap.netweaver.bc.rf.common.*;
import com.sap.netweaver.bc.rf.common.exception.*;

import com.sap.netweaver.bc.rf.common.support.NameInfo;

/**
 * Raised if the name of a resource is invalid. Examples: name is too long, name
 * contains forbidden characters.
 *
 * @created 14. April 2003
 */
public class ResourceNameInvalidException extends ResourceException {

  private NameInfo nameInfo;

  private final static boolean LOG_EXCEPTION_ON_CREATION = false;


  /**
   * Constructs a new exception.
   *
   * @param rid The identifier of the resource this exception belongs to.
   * @param nameInfo The repository name info.
   */
  public ResourceNameInvalidException(IRid rid, NameInfo nameInfo) {
    super(rid, ResourceNameInvalidException.LOG_EXCEPTION_ON_CREATION);
    this.nameInfo = nameInfo;
  }


  /**
   * Constructs a new exception.
   *
   * @param rid The identifier of the resource this exception belongs to.
   * @param message The exception message text (not localized).
   * @param args Exception arguments, can be <code>null</code> .
   * @param rootCause Throwable which caused this exception, can be <code>null
   *      </code>.
   * @param logExceptionOnCreation true: Message and stacktrace is logged.
   * @param nameInfo The repository name info.
   */
  public ResourceNameInvalidException(
    IRid rid, String message, Object[] args,
    Throwable rootCause, boolean logExceptionOnCreation,
    NameInfo nameInfo) {

    super(rid, message, args, rootCause, logExceptionOnCreation);
    this.nameInfo = nameInfo;
  }


  /**
   * Get the nameInfo attribute of the ResourceNameInvalidException object.
   *
   * @return The nameInfo value
   */
  public NameInfo getNameInfo() {
    return this.nameInfo;
  }

}
