/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.namespace;

/**
 * Class implementing a resource create descriptor used to create resources.
 *
 * @created 23. Januar 2003
 */
public class ResourceCreateDescriptor
   extends AbstractCreateDescriptor
   implements IResourceCreateDescriptor {
  protected IContentAndPropertiesDescriptor contentAndPropertiesDescriptor;

  /**
   * Construct object of class ResourceCreateDescriptor.
   *
   * @param destinationDescriptor destination of the resource to be created
   */
  public ResourceCreateDescriptor(IDestinationDescriptor destinationDescriptor) {
    super(destinationDescriptor);
    this.contentAndPropertiesDescriptor = null;
  }

  /**
   * Construct object of class ResourceCreateDescriptor.
   *
   * @param destinationDescriptor destination of the resource to be created
   * @param contentAndPropertiesDescriptor resource content and properties of
   *      the resource to be created
   */
  public ResourceCreateDescriptor(
    IDestinationDescriptor destinationDescriptor,
    IContentAndPropertiesDescriptor contentAndPropertiesDescriptor) {
    super(destinationDescriptor);
    this.contentAndPropertiesDescriptor = contentAndPropertiesDescriptor;
  }

  /**
   * Get resource content and properties of the resource to be operated.
   *
   * @return resource content and properties of the resource to be operated
   */
  public IContentAndPropertiesDescriptor getContentAndPropertiesDescriptor() {
    return contentAndPropertiesDescriptor;
  }
}
