/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.namespace;

import com.sap.netweaver.bc.rf.util.enum.*;

/**
 * Enumeration of position types of ordered collection elements.
 *
 * @created 29. Januar 2003
 */
public final class OrderPositionType extends EnumWithDescription {
  /*
   * A resource handle with such an attached order position (used in reorder
   * calls and the like) will be moved to the beginning of the containing
   * collection.
   */
  public final static OrderPositionType FIRST = new OrderPositionType(1, "First");

  /*
   * A resource handle with such an attached order position (used in reorder
   * calls and the like) will be moved to the end of the containing
   * collection.
   */
  public final static OrderPositionType LAST = new OrderPositionType(2, "Last");

  /*
   * A resource handle with such an attached order position (used in reorder
   * calls and the like) will be moved right before another resource handle
   * (reference point) in the containing collection.
   */
  public final static OrderPositionType BEFORE = new OrderPositionType(3, "Before");

  /*
   * A resource handle with such an attached order position (used in reorder
   * calls and the like) will be moved right after another resource handle
   * (reference point) in the containing collection.
   */
  public final static OrderPositionType AFTER = new OrderPositionType(4, "After");

  /**
   * Construct object of class OrderPositionType.
   *
   * @param id enumeration id
   * @param description enumeration description
   */
  private OrderPositionType(int id, String description) {
    super(id, description, false);
  }
}
