/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.namespace;

import com.sap.netweaver.bc.rf.util.enum.*;

/**
 * Enumeration of types of mechanisms for ordered collections.
 *
 * @created 29. Januar 2003
 */
public final class OrderMechanismType extends EnumWithDescription {
  /*
   * A collection with this order type isn't static and doesn't guarantee any
   * specific order of its children. The order of the children may therefore
   * change from call to call and usually isn't persisted.
   */
  public final static OrderMechanismType NONE = new OrderMechanismType(0, "None");

  /*
   * A collection with this order type is static, but doesn't allow manual
   * defintion of the order of its children. The order of the children
   * therefore must remain static from call to call, but usually is somehow
   * computed or statically persisted.
   */
  public final static OrderMechanismType SERVER = new OrderMechanismType(1, "Server");

  /*
   * A collection with this order type allows for manual defintion of the
   * order of its children. The order of the children therefore must remain
   * static from call to call and will be persisted.
   */
  public final static OrderMechanismType MANUAL = new OrderMechanismType(2, "Manual");

  /**
   * Construct object of class OrderMechanismType.
   *
   * @param id enumeration id
   * @param description enumeration description
   */
  private OrderMechanismType(int id, String description) {
    super(id, description, false);
  }
}
