/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.namespace;

/**
 * Class implementing mechanism identifier for ordered collections.
 *
 * @created 29. Januar 2003
 */
public class OrderMechanism {
  private final OrderMechanismType type;
  private final String specification;

  /**
   * Construct object of class OrderMechanism.
   *
   * @param type order mechanism type, identifying the general order mechanism
   *      applied, e.g. the order is totally determined by the client who has
   *      used reorder() calls to define the ordering
   */
  public OrderMechanism(OrderMechanismType type) {
    this.type = type;
    this.specification = null;
  }

  /**
   * Construct object of class OrderMechanism.
   *
   * @param type order mechanism type, identifying the general order mechanism
   *      applied, e.g. the order is totally determined by the client who has
   *      used reorder() calls to define the ordering
   * @param specification order mechanism specification, identifying the
   *      specific order mechanism applied, e.g. a specific kind of manual
   *      ordering by creation date, user or whatever
   */
  public OrderMechanism(OrderMechanismType type, String specification) {
    this.type = type;
    this.specification = specification;
  }

  /**
   * Get order mechanism type, identifying the general order mechanism applied,
   * e.g. the order is totally determined by the client who has used reorder()
   * calls to define the ordering.
   *
   * @return order mechanism type, identifying the general order mechanism
   *      applied, e.g. the order is totally determined by the client who has
   *      used reorder() calls to define the ordering
   */
  public OrderMechanismType getType() {
    return type;
  }

  /**
   * Get order mechanism specification, identifying the specific order mechanism
   * applied, e.g. a specific kind of manual ordering by creation date, user or
   * whatever.
   *
   * @return order mechanism specification, identifying the specific order
   *      mechanism applied, e.g. a specific kind of manual ordering by creation
   *      date, user or whatever
   */
  public String getSpecification() {
    return specification;
  }
}
