/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.namespace;

/**
 * Class implementing a resource move descriptor used to move resources.
 *
 * @created 21. Februar 2003
 */
public class MoveDescriptor implements IMoveDescriptor {
  protected IDestinationDescriptor destinationDescriptor;
  protected boolean propertyFailureToBeIgnored;

  /**
   * Construct object of class MoveDescriptor.
   *
   * @param destinationDescriptor destination of the resource to be operated
   */
  public MoveDescriptor(
    IDestinationDescriptor destinationDescriptor) {
    this.destinationDescriptor = destinationDescriptor;
    this.propertyFailureToBeIgnored = false;
  }

  /**
   * Construct object of class MoveDescriptor.
   *
   * @param destinationDescriptor destination of the resource to be operated
   * @param propertyFailureToBeIgnored flag whether or not property failures
   *      should be ignored while managing the resource
   */
  public MoveDescriptor(
    IDestinationDescriptor destinationDescriptor,
    boolean propertyFailureToBeIgnored) {
    this.destinationDescriptor = destinationDescriptor;
    this.propertyFailureToBeIgnored = propertyFailureToBeIgnored;
  }

  /**
   * Get destination of the resource to be operated.
   *
   * @return destination of the resource to be operated
   */
  public IDestinationDescriptor getDestinationDescriptor() {
    return destinationDescriptor;
  }

  /**
   * Get flag whether or not property failures should be ignored while operating
   * the resource.
   *
   * @return flag whether or not property failures should be ignored
   */
  public boolean isPropertyFailureToBeIgnored() {
    return propertyFailureToBeIgnored;
  }
}
