/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.namespace;

import com.sap.netweaver.bc.rf.util.enum.*;

/**
 * Enumeration of link tpyes.
 *
 * @author Vedran Lerenc
 * @created 29. Januar 2003
 */
public final class LinkType extends EnumWithDescription {
  /*
   * No specific link type.
   */
  public final static LinkType NONE = new LinkType(0, "None");

  /*
   * Repository dynamic link, that moves with the targets, i.e. if the target
   * is moved within the repository, the link will still point to the moved
   * target in that repository. This link type is limited to links stored in
   * the same repository as the target.
   */
  public final static LinkType REPOSITORY_DYNAMIC = new LinkType(1, "Repository Dynamic");

  /*
   * Internal static link, that statically points to a resource in an
   * arbitrary repository, i.e. when the resource is moved, the link will
   * still point to the same RID.
   */
  public final static LinkType INTERNAL_STATIC = new LinkType(2, "Internal Static");

  /*
   * External static link, that statically points to a general URI, i.e.
   * there is no context known to the link about the target and therefore it
   * always points to this URI.
   */
  public final static LinkType EXTERNAL_STATIC = new LinkType(3, "External Static");

  /**
   * Construct object of class LinkType.
   *
   * @param id enumeration id
   * @param description enumeration description
   */
  private LinkType(final int id, final String description) {
    super(id, description, false);
  }
}
