/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.namespace;

import com.sap.netweaver.bc.rf.common.*;

/**
 * Class implementing a link descriptor.
 *
 * @created 21. Februar 2003
 */
public class LinkDescriptor implements ILinkDescriptor {
  /**
   * Default link descriptor for resources not being a link (should be used for
   * performance reasons).
   */
  public final static ILinkDescriptor TYPE_NONE = new LinkDescriptor(LinkType.NONE);

  // Fields describing a link
  private LinkType linkType;
  private IRid targetRid;
  private IAbsoluteUri targetUri;

  /**
   * Construct object of class LinkDescriptor.
   *
   * @param linkType {@link LinkType} of the link
   */
  public LinkDescriptor(LinkType linkType) {
    this.linkType = linkType;
    this.targetRid = null;
    this.targetUri = null;
  }

  /**
   * Construct object of class LinkDescriptor.
   *
   * @param linkType {@link LinkType} of the link
   * @param targetRid target {@link IRid} of the link
   */
  public LinkDescriptor(LinkType linkType, IRid targetRid) {
    this.linkType = linkType;
    this.targetRid = targetRid;
    this.targetUri = null;
  }

  /**
   * Construct object of class LinkDescriptor.
   *
   * @param linkType {@link LinkType} of the link
   * @param targetUri target {@link IUri} of the link
   */
  public LinkDescriptor(LinkType linkType, IAbsoluteUri targetUri) {
    this.linkType = linkType;
    this.targetRid = null;
    this.targetUri = targetUri;
  }

  /**
   * Get {@link LinkType} of the link.
   *
   * @return {@link LinkType} of the link
   */
  public LinkType getLinkType() {
    return linkType;
  }

  /**
   * Get target {@link IRid} of the link. If the target is referenced by a
   * {@link IRid} depends on the link type.
   *
   * @return target {@link IRid} or null if this link type points to targets of
   *      another type
   */
  public IRid getTargetRid() {
    return targetRid;
  }

  /**
   * Get target {@link IUri} of the link. If the target is referenced by a
   * {@link IUri} depends on the link type.
   *
   * @return target {@link IUri} or null if this link type points to targets of
   *      another type
   */
  public IAbsoluteUri getTargetUri() {
    return targetUri;
  }
}
