/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.namespace;

/**
 * Class implementing a link create descriptor used to create links.
 *
 * @created 21. Februar 2003
 */
public class LinkCreateDescriptor extends ResourceCreateDescriptor implements ILinkCreateDescriptor {
  protected ILinkDescriptor linkDescriptor;

  /**
   * Construct object of class LinkCreateDescriptor.
   *
   * @param destinationDescriptor destination of the resource to be created
   * @param linkDescriptor link description of the link to be created
   */
  public LinkCreateDescriptor(IDestinationDescriptor destinationDescriptor,
    ILinkDescriptor linkDescriptor) {
    super(destinationDescriptor, null);
    this.linkDescriptor = linkDescriptor;
  }

  /**
   * Construct object of class LinkCreateDescriptor.
   *
   * @param destinationDescriptor destination of the resource to be created
   * @param contentAndPropertiesDescriptor resource content and properties of
   *      the resource to be created
   * @param linkDescriptor link description of the link to be created
   */
  public LinkCreateDescriptor(IDestinationDescriptor destinationDescriptor,
    IContentAndPropertiesDescriptor contentAndPropertiesDescriptor,
    ILinkDescriptor linkDescriptor) {
    super(destinationDescriptor, contentAndPropertiesDescriptor);
    this.linkDescriptor = linkDescriptor;
  }

  /**
   * Get link description of the link to be created.
   *
   * @return link description of the link to be created
   */
  public ILinkDescriptor getLinkDescriptor() {
    return linkDescriptor;
  }
}
