/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.namespace;

import com.sap.netweaver.bc.rf.common.IRid;
import com.sap.netweaver.bc.rf.common.exception.ResourceException;

/**
 * An invalid target was used for a copy or move operation.
 *
 * @created 14. April 2003
 */
public class InvalidTargetException extends ResourceException {

  private IRid invalidTarget;

  private final static boolean LOG_EXCEPTION_ON_CREATION = false;


  /**
   * Constructs a new exception.
   *
   * @param rid The identifier of the resource this exception belongs to.
   * @param invalidTarget The invalid identifier that was supplied by the
   *      client.
   */
  public InvalidTargetException(IRid rid, IRid invalidTarget) {
    super(rid, InvalidTargetException.LOG_EXCEPTION_ON_CREATION);
    this.invalidTarget = invalidTarget;
  }


  /**
   * Constructs a new exception.
   *
   * @param rid The identifier of the resource this exception belongs to.
   * @param message The exception message text (not localized).
   * @param args Exception arguments, can be <code>null</code> .
   * @param rootCause Throwable which caused this exception, can be <code>null
   *      </code>.
   * @param logExceptionOnCreation true: Message and stacktrace is logged.
   * @param invalidTarget The invalid identifier that was supplied by the
   *      client.
   */
  public InvalidTargetException(
    IRid rid, String message, Object[] args,
    Throwable rootCause, boolean logExceptionOnCreation,
    IRid invalidTarget) {

    super(rid, message, args, rootCause, logExceptionOnCreation);
    this.invalidTarget = invalidTarget;
  }


  /**
   * Returns the invalid target that caused the exception. Can be <code>null
   * </code> .
   *
   * @return the invalid target that caused the exception. Can be <code>null
   *      </code> .
   */
  public IRid getInvalidTargetRid() {
    return this.invalidTarget;
  }
}
