/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.namespace;

import java.util.*;

/**
 * Interface describing a return list giving access to the resultStateDescriptor
 * of a query used to identify the "session state" for upcoming calls.
 *
 * @created 20. Mrz 2003
 * @see com.sap.netweaver.bc.rf.mi.namespace.INamespaceManager
 */
public interface IResultStateList extends List {
  /**
   * Get resultStateDescriptor of the returned list of a paged call. This
   * descriptor is an optional parameter identifying a former query and their
   * results; it relies on the ability to keep a "session state" for upcoming
   * calls.
   *
   * @return resultStateDescriptor identifying a former query and their results
   */
  public Object getResultStateDescriptor();
}
