/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.namespace;

/**
 * Interface describing a move descriptor used to move resources.
 *
 * @created 23. Januar 2003
 */
public interface IMoveDescriptor {
  /**
   * Get destination of the resource to be operated.
   *
   * @return destination of the resource to be operated
   */
  public IDestinationDescriptor getDestinationDescriptor();

  /**
   * Get flag whether or not property failures should be ignored while operating
   * the resource.
   *
   * @return flag whether or not property failures should be ignored
   */
  public boolean isPropertyFailureToBeIgnored();
}
