/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.namespace;

import com.sap.netweaver.bc.rf.common.*;

/**
 * Interface describing a link descriptor.
 *
 * @created 21. Februar 2003
 */
public interface ILinkDescriptor {
  /**
   * Get {@link LinkType} of the link.
   *
   * @return The linkType value
   */
  public LinkType getLinkType();

  /**
   * Get target {@link RID} of the link. If the target is referenced by a {@link
   * RID} depends on the link type.
   *
   * @return target {@link RID} or null if this link type points to targets of
   *      another type
   */
  public IRid getTargetRid();

  /**
   * Get target {@link IUri} of the link. If the target is referenced by a
   * {@link IUri} depends on the link type.
   *
   * @return target {@link IUri} or null if this link type points to targets of
   *      another type
   */
  public IAbsoluteUri getTargetUri();
}
