/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.namespace;

import com.sap.netweaver.bc.rf.common.lock.*;

/**
 * Interface describing a create descriptor used to create resources of
 * arbitrary kind.
 *
 * @created 23. Januar 2003
 */
public interface ICreateDescriptor {
  /**
   * Get destination of the resource to be created.
   *
   * @return destination of the resource to be created
   */
  public IDestinationDescriptor getDestinationDescriptor();

  /**
   * Get lock descriptor to be applied atomically when creating the resource.
   *
   * @return lock descriptor
   */
  public ILockDescriptor getLockDescriptor();

  /**
   * Set lock descriptor to be applied atomically when creating the resource.
   *
   * @param lockDescriptor lock descriptor
   */
  public void setLockDescriptor(ILockDescriptor lockDescriptor);

  /**
   * Get lock info created atomically while creating the resource.
   *
   * @return lock info
   */
  public ILockInfo getLockInfo();

  /**
   * Set lock info created atomically while creating the resource.
   *
   * @param lockInfo lock info
   */
  public void setLockInfo(ILockInfo lockInfo);
}
