/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.namespace;

/**
 * Interface describing copy flags used to copy resources.
 *
 * @created 23. Januar 2003
 */
public interface ICopyFlagsDescriptor {
  /**
   * Get flag whether or not children should be copied.
   *
   * @return flag whether or not children should be copied
   */
  public boolean isCildrenToBeCopied();

  /**
   * Get flag whether or not child links of the given {@link LinkType} should be
   * copied.
   *
   * @param linkType link type
   * @return flag whether or not child links of the given {@link LinkType}
   *      should be copied
   */
  public boolean isChildrenLinkToBeCopied(LinkType linkType);
}
