/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.common.namespace;

import com.sap.netweaver.bc.rf.common.content.*;

import java.util.*;

/**
 * Interface describing content and properties of a resource.
 *
 * @created 23. Januar 2003
 */
public interface IContentAndPropertiesDescriptor {
  /**
   * Get content of the resource.
   *
   * @return content of the resource
   */
  public IMutableContent getContent();

  /**
   * Get list of {@link IProperty} instances of the resource.
   *
   * @return list of {@link IProperty} instances of the resource
   */
  public List getProperties();

  /**
   * Get flag whether or not property failures should be ignored while managing
   * the resource.
   *
   * @return flag whether or not property failures should be ignored
   */
  public boolean isPropertyFailureToBeIgnored();
}
